/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.util;

import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.CharArrayBuffer;
import java.io.Serializable;

public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 4359112959524048036L;
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer(int n2) {
        Args.notNegative(n2, "Buffer capacity");
        this.buffer = new byte[n2];
    }

    private void expand(int n2) {
        byte[] byArray = new byte[Math.max(this.buffer.length << 1, n2)];
        System.arraycopy(this.buffer, 0, byArray, 0, this.len);
        this.buffer = byArray;
    }

    public void append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len + n3;
        if (n4 > this.buffer.length) {
            this.expand(n4);
        }
        System.arraycopy(byArray, n2, this.buffer, this.len, n3);
        this.len = n4;
    }

    public void append(int n2) {
        int n3 = this.len + 1;
        if (n3 > this.buffer.length) {
            this.expand(n3);
        }
        this.buffer[this.len] = (byte)n2;
        this.len = n3;
    }

    public void append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len;
        int n5 = n4 + n3;
        if (n5 > this.buffer.length) {
            this.expand(n5);
        }
        int n6 = n2;
        for (int i2 = n4; i2 < n5; ++i2) {
            char c2 = cArray[n6];
            this.buffer[i2] = c2 >= ' ' && c2 <= '~' || c2 >= '\u00a0' && c2 <= '\u00ff' || c2 == '\t' ? (int)c2 : 63;
            ++n6;
        }
        this.len = n5;
    }

    public void append(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.buffer(), n2, n3);
    }

    public void clear() {
        this.len = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.len);
        }
        return byArray;
    }

    public int byteAt(int n2) {
        return this.buffer[n2];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.len;
    }

    public void ensureCapacity(int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.buffer.length - this.len;
        if (n2 > n3) {
            this.expand(this.len + n2);
        }
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public void setLength(int n2) {
        if (n2 < 0 || n2 > this.buffer.length) {
            throw new IndexOutOfBoundsException("len: " + n2 + " < 0 or > buffer len: " + this.buffer.length);
        }
        this.len = n2;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }

    public int indexOf(byte by, int n2, int n3) {
        int n4;
        int n5 = n2;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n4 = n3) > this.len) {
            n4 = this.len;
        }
        if (n5 > n4) {
            return -1;
        }
        for (int i2 = n5; i2 < n4; ++i2) {
            if (this.buffer[i2] != by) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(byte by) {
        return this.indexOf(by, 0, this.len);
    }
}

