/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.composite;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.composite.DefaultMergeStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.composite.MergeStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.util.ResolverUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.status.StatusConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Patterns;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Source;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.WatchManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Watcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CompositeConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    public static final String MERGE_STRATEGY_PROPERTY = "com.contrastsecurity.thirdparty.log4j.mergeStrategy";
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final List<? extends AbstractConfiguration> configurations;
    private MergeStrategy mergeStrategy;

    public CompositeConfiguration(List<? extends AbstractConfiguration> list) {
        super(list.get(0).getLoggerContext(), ConfigurationSource.COMPOSITE_SOURCE);
        Object object;
        this.rootNode = list.get(0).getRootNode();
        this.configurations = list;
        String string = PropertiesUtil.getProperties().getStringProperty(MERGE_STRATEGY_PROPERTY, DefaultMergeStrategy.class.getName());
        try {
            this.mergeStrategy = (MergeStrategy)Loader.newInstanceOf(string);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            object = reflectiveOperationException;
            this.mergeStrategy = new DefaultMergeStrategy();
        }
        for (AbstractConfiguration object2 : list) {
            this.mergeStrategy.mergeRootProperties(this.rootNode, object2);
        }
        object = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
        for (Map.Entry<String, String> entry : this.rootNode.getAttributes().entrySet()) {
            String string2 = entry.getKey();
            String string3 = this.getConfigurationStrSubstitutor().replace(entry.getValue());
            if ("status".equalsIgnoreCase(string2)) {
                ((StatusConfiguration)object).withStatus(string3.toUpperCase());
                continue;
            }
            if ("dest".equalsIgnoreCase(string2)) {
                ((StatusConfiguration)object).withDestination(string3);
                continue;
            }
            if ("shutdownHook".equalsIgnoreCase(string2)) {
                this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(string3);
                continue;
            }
            if ("shutdownTimeout".equalsIgnoreCase(string2)) {
                this.shutdownTimeoutMillis = Long.parseLong(string3);
                continue;
            }
            if ("verbose".equalsIgnoreCase(string2)) {
                ((StatusConfiguration)object).withVerbosity(string3);
                continue;
            }
            if ("packages".equalsIgnoreCase(string2)) {
                this.pluginPackages.addAll(Arrays.asList(string3.split(Patterns.COMMA_SEPARATOR)));
                continue;
            }
            if (!"name".equalsIgnoreCase(string2)) continue;
            this.setName(string3);
        }
        ((StatusConfiguration)object).initialize();
    }

    @Override
    public void setup() {
        AbstractConfiguration abstractConfiguration = this.configurations.get(0);
        this.staffChildConfiguration(abstractConfiguration);
        WatchManager watchManager = this.getWatchManager();
        WatchManager watchManager2 = abstractConfiguration.getWatchManager();
        if (watchManager2.getIntervalSeconds() > 0) {
            watchManager.setIntervalSeconds(watchManager2.getIntervalSeconds());
            Map<Source, Watcher> map = watchManager2.getConfigurationWatchers();
            for (Map.Entry<Source, Watcher> entry : map.entrySet()) {
                watchManager.watch(entry.getKey(), entry.getValue().newWatcher(this, this.listeners, entry.getValue().getLastModified()));
            }
        }
        for (AbstractConfiguration abstractConfiguration2 : this.configurations.subList(1, this.configurations.size())) {
            int n2;
            this.staffChildConfiguration(abstractConfiguration2);
            Node node = abstractConfiguration2.getRootNode();
            this.mergeStrategy.mergConfigurations(this.rootNode, node, this.getPluginManager());
            if (LOGGER.isEnabled(Level.ALL)) {
                StringBuilder stringBuilder = new StringBuilder();
                this.printNodes("", this.rootNode, stringBuilder);
                System.out.println(stringBuilder.toString());
            }
            if ((n2 = abstractConfiguration2.getWatchManager().getIntervalSeconds()) <= 0) continue;
            int n3 = watchManager.getIntervalSeconds();
            if (n3 <= 0 || n2 < n3) {
                watchManager.setIntervalSeconds(n2);
            }
            WatchManager watchManager3 = abstractConfiguration2.getWatchManager();
            Map<Source, Watcher> map = watchManager3.getConfigurationWatchers();
            for (Map.Entry<Source, Watcher> entry : map.entrySet()) {
                watchManager.watch(entry.getKey(), entry.getValue().newWatcher(this, this.listeners, entry.getValue().getLastModified()));
            }
        }
    }

    @Override
    public Configuration reconfigure() {
        LOGGER.debug("Reconfiguring composite configuration");
        ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        for (AbstractConfiguration abstractConfiguration : this.configurations) {
            ConfigurationSource configurationSource = abstractConfiguration.getConfigurationSource();
            URI uRI = configurationSource.getURI();
            Configuration configuration = abstractConfiguration;
            if (uRI == null) {
                LOGGER.warn("Unable to determine URI for configuration {}, changes to it will be ignored", (Object)abstractConfiguration.getName());
            } else {
                configuration = configurationFactory.getConfiguration(this.getLoggerContext(), abstractConfiguration.getName(), uRI);
                if (configuration == null) {
                    LOGGER.warn("Unable to reload configuration {}, changes to it will be ignored", (Object)abstractConfiguration.getName());
                }
            }
            arrayList.add((AbstractConfiguration)configuration);
        }
        return new CompositeConfiguration(arrayList);
    }

    private void staffChildConfiguration(AbstractConfiguration abstractConfiguration) {
        abstractConfiguration.setPluginManager(this.pluginManager);
        abstractConfiguration.setScriptManager(this.scriptManager);
        abstractConfiguration.setup();
    }

    private void printNodes(String string, Node node, StringBuilder stringBuilder) {
        stringBuilder.append(string).append(node.getName()).append(" type: ").append(node.getType()).append("\n");
        stringBuilder.append(string).append(node.getAttributes().toString()).append("\n");
        for (Node node2 : node.getChildren()) {
            this.printNodes(string + "  ", node2, stringBuilder);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + " [configurations=" + this.configurations + ", mergeStrategy=" + this.mergeStrategy + ", rootNode=" + this.rootNode + ", listeners=" + this.listeners + ", pluginPackages=" + this.pluginPackages + ", pluginManager=" + this.pluginManager + ", isShutdownHookEnabled=" + this.isShutdownHookEnabled + ", shutdownTimeoutMillis=" + this.shutdownTimeoutMillis + ", scriptManager=" + this.scriptManager + "]";
    }
}

