/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.LoggingException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.TlsSyslogFrame;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.AbstractLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.LoggerFields;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.internal.ExcludeChecker;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.internal.IncludeChecker;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.internal.ListChecker;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.Facility;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.Priority;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ThrowablePatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NetUtils;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Patterns;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.MessageCollectionMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.StructuredDataCollectionMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.StructuredDataId;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.message.StructuredDataMessage;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ProcessIdUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilders;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Plugin(name="Rfc5424Layout", category="Core", elementType="layout", printObject=true)
public final class Rfc5424Layout
extends AbstractStringLayout {
    public static final int DEFAULT_ENTERPRISE_NUMBER = 32473;
    public static final String DEFAULT_ID = "Audit";
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    public static final Pattern PARAM_VALUE_ESCAPE_PATTERN = Pattern.compile("[\\\"\\]\\\\]");
    public static final Pattern ENTERPRISE_ID_PATTERN = Pattern.compile("\\d+(\\.\\d+)*");
    public static final String DEFAULT_MDCID = "mdc";
    private static final String LF = "\n";
    private static final int TWO_DIGITS = 10;
    private static final int THREE_DIGITS = 100;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final String COMPONENT_KEY = "RFC5424-Converter";
    private final Facility facility;
    private final String defaultId;
    private final String enterpriseNumber;
    private final boolean includeMdc;
    private final String mdcId;
    private final StructuredDataId mdcSdId;
    private final String localHostName;
    private final String appName;
    private final String messageId;
    private final String configName;
    private final String mdcPrefix;
    private final String eventPrefix;
    private final List<String> mdcExcludes;
    private final List<String> mdcIncludes;
    private final List<String> mdcRequired;
    private final ListChecker listChecker;
    private final boolean includeNewLine;
    private final String escapeNewLine;
    private final boolean useTlsMessageFormat;
    private long lastTimestamp = -1L;
    private String timestamppStr;
    private final List<PatternFormatter> exceptionFormatters;
    private final Map<String, FieldFormatter> fieldFormatters;
    private final String procId;

    private Rfc5424Layout(Configuration configuration, Facility facility, String string, String string2, boolean bl2, boolean bl3, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, Charset charset, String string12, boolean bl4, LoggerFields[] loggerFieldsArray) {
        super(charset);
        Object object;
        PatternParser patternParser = Rfc5424Layout.createPatternParser(configuration, ThrowablePatternConverter.class);
        this.exceptionFormatters = string12 == null ? null : patternParser.parse(string12);
        this.facility = facility;
        this.defaultId = string == null ? DEFAULT_ID : string;
        this.enterpriseNumber = string2;
        this.includeMdc = bl2;
        this.includeNewLine = bl3;
        String string13 = this.escapeNewLine = string3 == null ? null : Matcher.quoteReplacement(string3);
        this.mdcId = string4 != null ? string4 : (string == null ? DEFAULT_MDCID : string);
        this.mdcSdId = new StructuredDataId(this.mdcId, this.enterpriseNumber, null, null);
        this.mdcPrefix = string5;
        this.eventPrefix = string6;
        this.appName = string7;
        this.messageId = string8;
        this.useTlsMessageFormat = bl4;
        this.localHostName = NetUtils.getLocalHostname();
        ListChecker listChecker = null;
        if (string9 != null) {
            object = string9.split(Patterns.COMMA_SEPARATOR);
            if (((String[])object).length > 0) {
                this.mdcExcludes = new ArrayList<String>(((String[])object).length);
                for (String string14 : object) {
                    this.mdcExcludes.add(string14.trim());
                }
                listChecker = new ExcludeChecker(this.mdcExcludes);
            } else {
                this.mdcExcludes = null;
            }
        } else {
            this.mdcExcludes = null;
        }
        if (string10 != null) {
            object = string10.split(Patterns.COMMA_SEPARATOR);
            if (((String[])object).length > 0) {
                this.mdcIncludes = new ArrayList<String>(((String[])object).length);
                for (String string14 : object) {
                    this.mdcIncludes.add(string14.trim());
                }
                listChecker = new IncludeChecker(this.mdcIncludes);
            } else {
                this.mdcIncludes = null;
            }
        } else {
            this.mdcIncludes = null;
        }
        if (string11 != null) {
            object = string11.split(Patterns.COMMA_SEPARATOR);
            if (((String[])object).length > 0) {
                this.mdcRequired = new ArrayList<String>(((String[])object).length);
                for (String string14 : object) {
                    this.mdcRequired.add(string14.trim());
                }
            } else {
                this.mdcRequired = null;
            }
        } else {
            this.mdcRequired = null;
        }
        this.listChecker = listChecker != null ? listChecker : ListChecker.NOOP_CHECKER;
        object = configuration == null ? null : configuration.getName();
        this.configName = Strings.isNotEmpty((CharSequence)object) ? object : null;
        this.fieldFormatters = this.createFieldFormatters(loggerFieldsArray, configuration);
        this.procId = ProcessIdUtil.getProcessId();
    }

    private Map<String, FieldFormatter> createFieldFormatters(LoggerFields[] loggerFieldsArray, Configuration configuration) {
        HashMap<String, FieldFormatter> hashMap = new HashMap<String, FieldFormatter>(loggerFieldsArray == null ? 0 : loggerFieldsArray.length);
        if (loggerFieldsArray != null) {
            for (LoggerFields loggerFields : loggerFieldsArray) {
                StructuredDataId structuredDataId = loggerFields.getSdId() == null ? this.mdcSdId : loggerFields.getSdId();
                HashMap<String, List<PatternFormatter>> hashMap2 = new HashMap<String, List<PatternFormatter>>();
                Map<String, String> map = loggerFields.getMap();
                if (map.isEmpty()) continue;
                PatternParser patternParser = Rfc5424Layout.createPatternParser(configuration, null);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    List<PatternFormatter> list = patternParser.parse(entry.getValue());
                    hashMap2.put(entry.getKey(), list);
                }
                FieldFormatter fieldFormatter = new FieldFormatter(hashMap2, loggerFields.getDiscardIfAllFieldsAreEmpty());
                hashMap.put(structuredDataId.toString(), fieldFormatter);
            }
        }
        return hashMap.size() > 0 ? hashMap : null;
    }

    private static PatternParser createPatternParser(Configuration configuration, Class<? extends PatternConverter> clazz) {
        if (configuration == null) {
            return new PatternParser(configuration, "Converter", LogEventPatternConverter.class, clazz);
        }
        PatternParser patternParser = (PatternParser)configuration.getComponent(COMPONENT_KEY);
        if (patternParser == null) {
            patternParser = new PatternParser(configuration, "Converter", ThrowablePatternConverter.class);
            configuration.addComponent(COMPONENT_KEY, patternParser);
            patternParser = (PatternParser)configuration.getComponent(COMPONENT_KEY);
        }
        return patternParser;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("structured", "true");
        hashMap.put("formatType", "RFC5424");
        return hashMap;
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilder stringBuilder = Rfc5424Layout.getStringBuilder();
        this.appendPriority(stringBuilder, logEvent.getLevel());
        this.appendTimestamp(stringBuilder, logEvent.getTimeMillis());
        this.appendSpace(stringBuilder);
        this.appendHostName(stringBuilder);
        this.appendSpace(stringBuilder);
        this.appendAppName(stringBuilder);
        this.appendSpace(stringBuilder);
        this.appendProcessId(stringBuilder);
        this.appendSpace(stringBuilder);
        this.appendMessageId(stringBuilder, logEvent.getMessage());
        this.appendSpace(stringBuilder);
        this.appendStructuredElements(stringBuilder, logEvent);
        this.appendMessage(stringBuilder, logEvent);
        if (this.useTlsMessageFormat) {
            return new TlsSyslogFrame(stringBuilder.toString()).toString();
        }
        return stringBuilder.toString();
    }

    private void appendPriority(StringBuilder stringBuilder, Level level) {
        stringBuilder.append('<');
        stringBuilder.append(Priority.getPriority(this.facility, level));
        stringBuilder.append(">1 ");
    }

    private void appendTimestamp(StringBuilder stringBuilder, long l2) {
        stringBuilder.append(this.computeTimeStampString(l2));
    }

    private void appendSpace(StringBuilder stringBuilder) {
        stringBuilder.append(' ');
    }

    private void appendHostName(StringBuilder stringBuilder) {
        stringBuilder.append(this.localHostName);
    }

    private void appendAppName(StringBuilder stringBuilder) {
        if (this.appName != null) {
            stringBuilder.append(this.appName);
        } else if (this.configName != null) {
            stringBuilder.append(this.configName);
        } else {
            stringBuilder.append('-');
        }
    }

    private void appendProcessId(StringBuilder stringBuilder) {
        stringBuilder.append(this.getProcId());
    }

    private void appendMessageId(StringBuilder stringBuilder, Message message) {
        String string;
        boolean bl2 = message instanceof StructuredDataMessage;
        String string2 = string = bl2 ? ((StructuredDataMessage)message).getType() : null;
        if (string != null) {
            stringBuilder.append(string);
        } else if (this.messageId != null) {
            stringBuilder.append(this.messageId);
        } else {
            stringBuilder.append('-');
        }
    }

    private void appendMessage(StringBuilder stringBuilder, LogEvent logEvent) {
        String string;
        Message message = logEvent.getMessage();
        String string2 = string = message instanceof StructuredDataMessage || message instanceof MessageCollectionMessage ? message.getFormat() : message.getFormattedMessage();
        if (string != null && string.length() > 0) {
            stringBuilder.append(' ').append(this.escapeNewlines(string, this.escapeNewLine));
        }
        if (this.exceptionFormatters != null && logEvent.getThrown() != null) {
            StringBuilder stringBuilder2 = new StringBuilder(LF);
            for (PatternFormatter patternFormatter : this.exceptionFormatters) {
                patternFormatter.format(logEvent, stringBuilder2);
            }
            stringBuilder.append(this.escapeNewlines(stringBuilder2.toString(), this.escapeNewLine));
        }
        if (this.includeNewLine) {
            stringBuilder.append(LF);
        }
    }

    private void appendStructuredElements(StringBuilder stringBuilder, LogEvent logEvent) {
        Object object;
        boolean bl2;
        Message message = logEvent.getMessage();
        boolean bl3 = bl2 = message instanceof StructuredDataMessage || message instanceof StructuredDataCollectionMessage;
        if (!bl2 && this.fieldFormatters != null && this.fieldFormatters.isEmpty() && !this.includeMdc) {
            stringBuilder.append('-');
            return;
        }
        HashMap<String, StructuredDataElement> hashMap = new HashMap<String, StructuredDataElement>();
        Map<String, String> map = logEvent.getContextData().toMap();
        if (this.mdcRequired != null) {
            this.checkRequired(map);
        }
        if (this.fieldFormatters != null) {
            for (Map.Entry<String, FieldFormatter> object2 : this.fieldFormatters.entrySet()) {
                object = object2.getKey();
                StructuredDataElement structuredDataElement = object2.getValue().format(logEvent);
                hashMap.put((String)object, structuredDataElement);
            }
        }
        if (this.includeMdc && map.size() > 0) {
            String string = this.mdcSdId.toString();
            StructuredDataElement structuredDataElement = (StructuredDataElement)hashMap.get(string);
            if (structuredDataElement != null) {
                structuredDataElement.union(map);
                hashMap.put(string, structuredDataElement);
            } else {
                object = new StructuredDataElement(map, this.mdcPrefix, false);
                hashMap.put(string, (StructuredDataElement)object);
            }
        }
        if (bl2) {
            if (message instanceof MessageCollectionMessage) {
                for (StructuredDataMessage structuredDataMessage : (StructuredDataCollectionMessage)message) {
                    this.addStructuredData(hashMap, structuredDataMessage);
                }
            } else {
                this.addStructuredData(hashMap, (StructuredDataMessage)message);
            }
        }
        if (hashMap.isEmpty()) {
            stringBuilder.append('-');
            return;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.formatStructuredElement((String)entry.getKey(), (StructuredDataElement)entry.getValue(), stringBuilder, this.listChecker);
        }
    }

    private void addStructuredData(Map<String, StructuredDataElement> map, StructuredDataMessage structuredDataMessage) {
        Map<String, String> map2 = structuredDataMessage.getData();
        StructuredDataId structuredDataId = structuredDataMessage.getId();
        String string = this.getId(structuredDataId);
        if (map.containsKey(string)) {
            StructuredDataElement structuredDataElement = map.get(structuredDataId.toString());
            structuredDataElement.union(map2);
            map.put(string, structuredDataElement);
        } else {
            StructuredDataElement structuredDataElement = new StructuredDataElement(map2, this.eventPrefix, false);
            map.put(string, structuredDataElement);
        }
    }

    private String escapeNewlines(String string, String string2) {
        if (null == string2) {
            return string;
        }
        return NEWLINE_PATTERN.matcher(string).replaceAll(string2);
    }

    protected String getProcId() {
        return this.procId;
    }

    protected List<String> getMdcExcludes() {
        return this.mdcExcludes;
    }

    protected List<String> getMdcIncludes() {
        return this.mdcIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeTimeStampString(long l2) {
        long l3;
        Object object = this;
        synchronized (object) {
            l3 = this.lastTimestamp;
            if (l2 == this.lastTimestamp) {
                return this.timestamppStr;
            }
        }
        object = new StringBuilder();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l2);
        ((StringBuilder)object).append(Integer.toString(gregorianCalendar.get(1)));
        ((StringBuilder)object).append('-');
        this.pad(gregorianCalendar.get(2) + 1, 10, (StringBuilder)object);
        ((StringBuilder)object).append('-');
        this.pad(gregorianCalendar.get(5), 10, (StringBuilder)object);
        ((StringBuilder)object).append('T');
        this.pad(gregorianCalendar.get(11), 10, (StringBuilder)object);
        ((StringBuilder)object).append(':');
        this.pad(gregorianCalendar.get(12), 10, (StringBuilder)object);
        ((StringBuilder)object).append(':');
        this.pad(gregorianCalendar.get(13), 10, (StringBuilder)object);
        ((StringBuilder)object).append('.');
        this.pad(gregorianCalendar.get(14), 100, (StringBuilder)object);
        int n2 = (gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000;
        if (n2 == 0) {
            ((StringBuilder)object).append('Z');
        } else {
            if (n2 < 0) {
                n2 = -n2;
                ((StringBuilder)object).append('-');
            } else {
                ((StringBuilder)object).append('+');
            }
            int n3 = n2 / 60;
            this.pad(n3, 10, (StringBuilder)object);
            ((StringBuilder)object).append(':');
            this.pad(n2 -= n3 * 60, 10, (StringBuilder)object);
        }
        Rfc5424Layout rfc5424Layout = this;
        synchronized (rfc5424Layout) {
            if (l3 == this.lastTimestamp) {
                this.lastTimestamp = l2;
                this.timestamppStr = ((StringBuilder)object).toString();
            }
        }
        return ((StringBuilder)object).toString();
    }

    private void pad(int n2, int n3, StringBuilder stringBuilder) {
        while (n3 > 1) {
            if (n2 < n3) {
                stringBuilder.append('0');
            }
            n3 /= 10;
        }
        stringBuilder.append(Integer.toString(n2));
    }

    private void formatStructuredElement(String string, StructuredDataElement structuredDataElement, StringBuilder stringBuilder, ListChecker listChecker) {
        if (string == null && this.defaultId == null || structuredDataElement.discard()) {
            return;
        }
        stringBuilder.append('[');
        stringBuilder.append(string);
        if (!this.mdcSdId.toString().equals(string)) {
            this.appendMap(structuredDataElement.getPrefix(), structuredDataElement.getFields(), stringBuilder, ListChecker.NOOP_CHECKER);
        } else {
            this.appendMap(structuredDataElement.getPrefix(), structuredDataElement.getFields(), stringBuilder, listChecker);
        }
        stringBuilder.append(']');
    }

    private String getId(StructuredDataId structuredDataId) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (structuredDataId == null || structuredDataId.getName() == null) {
            stringBuilder.append(this.defaultId);
        } else {
            stringBuilder.append(structuredDataId.getName());
        }
        String string2 = string = structuredDataId != null ? structuredDataId.getEnterpriseNumber() : this.enterpriseNumber;
        if ("-1".equals(string)) {
            string = this.enterpriseNumber;
        }
        if (!"-1".equals(string)) {
            stringBuilder.append('@').append(string);
        }
        return stringBuilder.toString();
    }

    private void checkRequired(Map<String, String> map) {
        for (String string : this.mdcRequired) {
            String string2 = map.get(string);
            if (string2 != null) continue;
            throw new LoggingException("Required key " + string + " is missing from the " + this.mdcId);
        }
    }

    private void appendMap(String string, Map<String, String> map, StringBuilder stringBuilder, ListChecker listChecker) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(map);
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!listChecker.check((String)entry.getKey()) || entry.getValue() == null) continue;
            stringBuilder.append(' ');
            if (string != null) {
                stringBuilder.append(string);
            }
            String string2 = this.escapeNewlines(this.escapeSDParams((String)entry.getKey()), this.escapeNewLine);
            String string3 = this.escapeNewlines(this.escapeSDParams((String)entry.getValue()), this.escapeNewLine);
            StringBuilders.appendKeyDqValue(stringBuilder, string2, string3);
        }
    }

    private String escapeSDParams(String string) {
        return PARAM_VALUE_ESCAPE_PATTERN.matcher(string).replaceAll("\\\\$0");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("facility=").append(this.facility.name());
        stringBuilder.append(" appName=").append(this.appName);
        stringBuilder.append(" defaultId=").append(this.defaultId);
        stringBuilder.append(" enterpriseNumber=").append(this.enterpriseNumber);
        stringBuilder.append(" newLine=").append(this.includeNewLine);
        stringBuilder.append(" includeMDC=").append(this.includeMdc);
        stringBuilder.append(" messageId=").append(this.messageId);
        return stringBuilder.toString();
    }

    @PluginFactory
    public static Rfc5424Layout createLayout(@PluginAttribute(value="facility", defaultString="LOCAL0") Facility facility, @PluginAttribute(value="id") String string, @PluginAttribute(value="enterpriseNumber", defaultInt=32473) int n2, @PluginAttribute(value="includeMDC", defaultBoolean=true) boolean bl2, @PluginAttribute(value="mdcId", defaultString="mdc") String string2, @PluginAttribute(value="mdcPrefix") String string3, @PluginAttribute(value="eventPrefix") String string4, @PluginAttribute(value="newLine") boolean bl3, @PluginAttribute(value="newLineEscape") String string5, @PluginAttribute(value="appName") String string6, @PluginAttribute(value="messageId") String string7, @PluginAttribute(value="mdcExcludes") String string8, @PluginAttribute(value="mdcIncludes") String string9, @PluginAttribute(value="mdcRequired") String string10, @PluginAttribute(value="exceptionPattern") String string11, @PluginAttribute(value="useTlsMessageFormat") boolean bl4, @PluginElement(value="LoggerFields") LoggerFields[] loggerFieldsArray, @PluginConfiguration Configuration configuration) {
        if (string9 != null && string8 != null) {
            LOGGER.error("mdcIncludes and mdcExcludes are mutually exclusive. Includes wil be ignored");
            string9 = null;
        }
        return new Rfc5424Layout(configuration, facility, string, String.valueOf(n2), bl2, bl3, string5, string2, string3, string4, string6, string7, string8, string9, string10, StandardCharsets.UTF_8, string11, bl4, loggerFieldsArray);
    }

    public Facility getFacility() {
        return this.facility;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public String getEnterpriseNumber() {
        return this.enterpriseNumber;
    }

    public boolean isIncludeMdc() {
        return this.includeMdc;
    }

    public String getMdcId() {
        return this.mdcId;
    }

    private class StructuredDataElement {
        private final Map<String, String> fields;
        private final boolean discardIfEmpty;
        private final String prefix;

        public StructuredDataElement(Map<String, String> map, String string, boolean bl2) {
            this.discardIfEmpty = bl2;
            this.fields = map;
            this.prefix = string;
        }

        boolean discard() {
            if (!this.discardIfEmpty) {
                return false;
            }
            boolean bl2 = false;
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                if (!Strings.isNotEmpty(entry.getValue())) continue;
                bl2 = true;
                break;
            }
            return !bl2;
        }

        void union(Map<String, String> map) {
            this.fields.putAll(map);
        }

        Map<String, String> getFields() {
            return this.fields;
        }

        String getPrefix() {
            return this.prefix;
        }
    }

    private class FieldFormatter {
        private final Map<String, List<PatternFormatter>> delegateMap;
        private final boolean discardIfEmpty;

        public FieldFormatter(Map<String, List<PatternFormatter>> map, boolean bl2) {
            this.discardIfEmpty = bl2;
            this.delegateMap = map;
        }

        public StructuredDataElement format(LogEvent logEvent) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.delegateMap.size());
            for (Map.Entry<String, List<PatternFormatter>> entry : this.delegateMap.entrySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (PatternFormatter patternFormatter : entry.getValue()) {
                    patternFormatter.format(logEvent, stringBuilder);
                }
                hashMap.put(entry.getKey(), stringBuilder.toString());
            }
            return new StructuredDataElement(hashMap, Rfc5424Layout.this.eventPrefix, this.discardIfEmpty);
        }
    }

    public static class Rfc5424LayoutBuilder {
        private Configuration config;
        private Facility facility = Facility.LOCAL0;
        private String id;
        private String ein = String.valueOf(32473);
        private boolean includeMDC = true;
        private boolean includeNL;
        private String escapeNL;
        private String mdcId = "mdc";
        private String mdcPrefix;
        private String eventPrefix;
        private String appName;
        private String messageId;
        private String excludes;
        private String includes;
        private String required;
        private Charset charset;
        private String exceptionPattern;
        private boolean useTLSMessageFormat;
        private LoggerFields[] loggerFields;

        public Rfc5424LayoutBuilder setConfig(Configuration configuration) {
            this.config = configuration;
            return this;
        }

        public Rfc5424LayoutBuilder setFacility(Facility facility) {
            this.facility = facility;
            return this;
        }

        public Rfc5424LayoutBuilder setId(String string) {
            this.id = string;
            return this;
        }

        public Rfc5424LayoutBuilder setEin(String string) {
            this.ein = string;
            return this;
        }

        public Rfc5424LayoutBuilder setIncludeMDC(boolean bl2) {
            this.includeMDC = bl2;
            return this;
        }

        public Rfc5424LayoutBuilder setIncludeNL(boolean bl2) {
            this.includeNL = bl2;
            return this;
        }

        public Rfc5424LayoutBuilder setEscapeNL(String string) {
            this.escapeNL = string;
            return this;
        }

        public Rfc5424LayoutBuilder setMdcId(String string) {
            this.mdcId = string;
            return this;
        }

        public Rfc5424LayoutBuilder setMdcPrefix(String string) {
            this.mdcPrefix = string;
            return this;
        }

        public Rfc5424LayoutBuilder setEventPrefix(String string) {
            this.eventPrefix = string;
            return this;
        }

        public Rfc5424LayoutBuilder setAppName(String string) {
            this.appName = string;
            return this;
        }

        public Rfc5424LayoutBuilder setMessageId(String string) {
            this.messageId = string;
            return this;
        }

        public Rfc5424LayoutBuilder setExcludes(String string) {
            this.excludes = string;
            return this;
        }

        public Rfc5424LayoutBuilder setIncludes(String string) {
            this.includes = string;
            return this;
        }

        public Rfc5424LayoutBuilder setRequired(String string) {
            this.required = string;
            return this;
        }

        public Rfc5424LayoutBuilder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Rfc5424LayoutBuilder setExceptionPattern(String string) {
            this.exceptionPattern = string;
            return this;
        }

        public Rfc5424LayoutBuilder setUseTLSMessageFormat(boolean bl2) {
            this.useTLSMessageFormat = bl2;
            return this;
        }

        public Rfc5424LayoutBuilder setLoggerFields(LoggerFields[] loggerFieldsArray) {
            this.loggerFields = loggerFieldsArray;
            return this;
        }

        public Rfc5424Layout build() {
            if (this.includes != null && this.excludes != null) {
                AbstractLayout.LOGGER.error("mdcIncludes and mdcExcludes are mutually exclusive. Includes wil be ignored");
                this.includes = null;
            }
            if (this.ein != null && !ENTERPRISE_ID_PATTERN.matcher(this.ein).matches()) {
                AbstractLayout.LOGGER.warn(String.format("provided EID %s is not in valid format!", this.ein));
                return null;
            }
            return new Rfc5424Layout(this.config, this.facility, this.id, this.ein, this.includeMDC, this.includeNL, this.escapeNL, this.mdcId, this.mdcPrefix, this.eventPrefix, this.appName, this.messageId, this.excludes, this.includes, this.required, this.charset, this.exceptionPattern, this.useTLSMessageFormat, this.loggerFields);
        }
    }
}

