/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.ByteBufferDestinationHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class TextEncoderHelper {
    private TextEncoderHelper() {
    }

    static void encodeTextFallBack(Charset charset, StringBuilder stringBuilder, ByteBufferDestination byteBufferDestination) {
        byte[] byArray = stringBuilder.toString().getBytes(charset);
        byteBufferDestination.writeBytes(byArray, 0, byArray.length);
    }

    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer, StringBuilder stringBuilder, ByteBufferDestination byteBufferDestination) {
        charsetEncoder.reset();
        if (stringBuilder.length() > charBuffer.capacity()) {
            TextEncoderHelper.encodeChunkedText(charsetEncoder, charBuffer, byteBuffer, stringBuilder, byteBufferDestination);
            return;
        }
        charBuffer.clear();
        stringBuilder.getChars(0, stringBuilder.length(), charBuffer.array(), charBuffer.arrayOffset());
        charBuffer.limit(stringBuilder.length());
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        TextEncoderHelper.writeEncodedText(charsetEncoder, charBuffer, byteBuffer, byteBufferDestination, coderResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer, ByteBufferDestination byteBufferDestination, CoderResult coderResult) {
        if (!coderResult.isUnderflow()) {
            TextEncoderHelper.writeChunkedEncodedText(charsetEncoder, charBuffer, byteBufferDestination, byteBuffer, coderResult);
            return;
        }
        coderResult = charsetEncoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) {
            ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
            synchronized (byteBufferDestination2) {
                TextEncoderHelper.flushRemainingBytes(charsetEncoder, byteBufferDestination, byteBuffer);
            }
            return;
        }
        if (byteBuffer != byteBufferDestination.getByteBuffer()) {
            byteBuffer.flip();
            byteBufferDestination.writeBytes(byteBuffer);
            byteBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChunkedEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBufferDestination byteBufferDestination, ByteBuffer byteBuffer, CoderResult coderResult) {
        ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
        synchronized (byteBufferDestination2) {
            byteBuffer = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuffer, true, byteBufferDestination, byteBuffer, coderResult);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, byteBufferDestination, byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeChunkedText(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer, StringBuilder stringBuilder, ByteBufferDestination byteBufferDestination) {
        int n2 = 0;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        boolean bl2 = false;
        while (!bl2 && coderResult.isUnderflow()) {
            charBuffer.clear();
            int n3 = TextEncoderHelper.copy(stringBuilder, n2, charBuffer);
            bl2 = (n2 += n3) >= stringBuilder.length();
            charBuffer.flip();
            coderResult = charsetEncoder.encode(charBuffer, byteBuffer, bl2);
        }
        if (bl2) {
            TextEncoderHelper.writeEncodedText(charsetEncoder, charBuffer, byteBuffer, byteBufferDestination, coderResult);
            return;
        }
        ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
        synchronized (byteBufferDestination2) {
            byteBuffer = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuffer, bl2, byteBufferDestination, byteBuffer, coderResult);
            while (!bl2) {
                coderResult = CoderResult.UNDERFLOW;
                while (!bl2 && coderResult.isUnderflow()) {
                    charBuffer.clear();
                    int n4 = TextEncoderHelper.copy(stringBuilder, n2, charBuffer);
                    bl2 = (n2 += n4) >= stringBuilder.length();
                    charBuffer.flip();
                    coderResult = charsetEncoder.encode(charBuffer, byteBuffer, bl2);
                }
                byteBuffer = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuffer, bl2, byteBufferDestination, byteBuffer, coderResult);
            }
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, byteBufferDestination, byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuffer, ByteBufferDestination byteBufferDestination) {
        charsetEncoder.reset();
        ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
        synchronized (byteBufferDestination2) {
            ByteBuffer byteBuffer = byteBufferDestination.getByteBuffer();
            byteBuffer = TextEncoderHelper.encodeAsMuchAsPossible(charsetEncoder, charBuffer, true, byteBufferDestination, byteBuffer);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder, byteBufferDestination, byteBuffer);
        }
    }

    private static ByteBuffer writeAndEncodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuffer, boolean bl2, ByteBufferDestination byteBufferDestination, ByteBuffer byteBuffer, CoderResult coderResult) {
        while (true) {
            byteBuffer = TextEncoderHelper.drainIfByteBufferFull(byteBufferDestination, byteBuffer, coderResult);
            if (!coderResult.isOverflow()) break;
            coderResult = charsetEncoder.encode(charBuffer, byteBuffer, bl2);
        }
        if (!coderResult.isUnderflow()) {
            TextEncoderHelper.throwException(coderResult);
        }
        return byteBuffer;
    }

    private static void throwException(CoderResult coderResult) {
        try {
            coderResult.throwException();
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
    }

    private static ByteBuffer encodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuffer, boolean bl2, ByteBufferDestination byteBufferDestination, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        do {
            coderResult = charsetEncoder.encode(charBuffer, byteBuffer, bl2);
            byteBuffer = TextEncoderHelper.drainIfByteBufferFull(byteBufferDestination, byteBuffer, coderResult);
        } while (coderResult.isOverflow());
        if (!coderResult.isUnderflow()) {
            TextEncoderHelper.throwException(coderResult);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer drainIfByteBufferFull(ByteBufferDestination byteBufferDestination, ByteBuffer byteBuffer, CoderResult coderResult) {
        if (coderResult.isOverflow()) {
            ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
            synchronized (byteBufferDestination2) {
                ByteBuffer byteBuffer2 = byteBufferDestination.getByteBuffer();
                if (byteBuffer2 != byteBuffer) {
                    byteBuffer.flip();
                    ByteBufferDestinationHelper.writeToUnsynchronized(byteBuffer, byteBufferDestination);
                    byteBuffer.clear();
                    return byteBufferDestination.getByteBuffer();
                }
                return byteBufferDestination.drain(byteBuffer2);
            }
        }
        return byteBuffer;
    }

    private static void flushRemainingBytes(CharsetEncoder charsetEncoder, ByteBufferDestination byteBufferDestination, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        do {
            coderResult = charsetEncoder.flush(byteBuffer);
            byteBuffer = TextEncoderHelper.drainIfByteBufferFull(byteBufferDestination, byteBuffer, coderResult);
        } while (coderResult.isOverflow());
        if (!coderResult.isUnderflow()) {
            TextEncoderHelper.throwException(coderResult);
        }
        if (byteBuffer.remaining() > 0 && byteBuffer != byteBufferDestination.getByteBuffer()) {
            byteBuffer.flip();
            ByteBufferDestinationHelper.writeToUnsynchronized(byteBuffer, byteBufferDestination);
            byteBuffer.clear();
        }
    }

    static int copy(StringBuilder stringBuilder, int n2, CharBuffer charBuffer) {
        int n3 = Math.min(stringBuilder.length() - n2, charBuffer.remaining());
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.position();
        stringBuilder.getChars(n2, n2 + n3, cArray, charBuffer.arrayOffset() + n4);
        charBuffer.position(n4 + n3);
        return n3;
    }
}

