/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.ThrowableProxy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ThrowablePatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;

@Plugin(name="RootThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"rEx", "rThrowable", "rException"})
public final class RootThrowablePatternConverter
extends ThrowablePatternConverter {
    private RootThrowablePatternConverter(Configuration configuration, String[] stringArray) {
        super("RootThrowable", "throwable", stringArray, configuration);
    }

    public static RootThrowablePatternConverter newInstance(Configuration configuration, String[] stringArray) {
        return new RootThrowablePatternConverter(configuration, stringArray);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        ThrowableProxy throwableProxy = logEvent.getThrownProxy();
        Throwable throwable = logEvent.getThrown();
        if (throwable != null && this.options.anyLines()) {
            if (throwableProxy == null) {
                super.format(logEvent, stringBuilder);
                return;
            }
            String string = throwableProxy.getCauseStackTraceAsString(this.options.getIgnorePackages(), this.options.getTextRenderer(), this.getSuffix(logEvent), this.options.getSeparator());
            int n2 = stringBuilder.length();
            if (n2 > 0 && !Character.isWhitespace(stringBuilder.charAt(n2 - 1))) {
                stringBuilder.append(' ');
            }
            if (!this.options.allLines() || !Strings.LINE_SEPARATOR.equals(this.options.getSeparator())) {
                StringBuilder stringBuilder2 = new StringBuilder();
                String[] stringArray = string.split(Strings.LINE_SEPARATOR);
                int n3 = this.options.minLines(stringArray.length) - 1;
                for (int i2 = 0; i2 <= n3; ++i2) {
                    stringBuilder2.append(stringArray[i2]);
                    if (i2 >= n3) continue;
                    stringBuilder2.append(this.options.getSeparator());
                }
                stringBuilder.append(stringBuilder2.toString());
            } else {
                stringBuilder.append(string);
            }
        }
    }
}

