/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationListener;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.AbstractWatcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.FileWatcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Source;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Watcher;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class WrappedFileWatcher
extends AbstractWatcher
implements FileWatcher {
    private final FileWatcher watcher;
    private volatile long lastModifiedMillis;

    public WrappedFileWatcher(FileWatcher fileWatcher, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        super(configuration, reconfigurable, list);
        this.watcher = fileWatcher;
        this.lastModifiedMillis = l2;
    }

    public WrappedFileWatcher(FileWatcher fileWatcher) {
        super(null, null, null);
        this.watcher = fileWatcher;
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedMillis;
    }

    @Override
    public void fileModified(File file) {
        this.watcher.fileModified(file);
    }

    @Override
    public boolean isModified() {
        long l2 = this.getSource().getFile().lastModified();
        if (this.lastModifiedMillis != l2) {
            this.lastModifiedMillis = l2;
            return true;
        }
        return false;
    }

    @Override
    public List<ConfigurationListener> getListeners() {
        if (super.getListeners() != null) {
            return Collections.unmodifiableList(super.getListeners());
        }
        return null;
    }

    @Override
    public void modified() {
        if (this.getListeners() != null) {
            super.modified();
        }
        this.fileModified(this.getSource().getFile());
        this.lastModifiedMillis = this.getSource().getFile().lastModified();
    }

    @Override
    public void watching(Source source) {
        this.lastModifiedMillis = source.getFile().lastModified();
        super.watching(source);
    }

    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        WrappedFileWatcher wrappedFileWatcher = new WrappedFileWatcher(this.watcher, this.getConfiguration(), reconfigurable, list, l2);
        if (this.getSource() != null) {
            wrappedFileWatcher.watching(this.getSource());
        }
        return wrappedFileWatcher;
    }
}

