/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.datetime;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.time.Instant;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.datetime.FastDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class FixedDateFormat {
    private static final char NONE = '\u0000';
    private final FixedFormat fixedFormat;
    private final TimeZone timeZone;
    private final int length;
    private final int secondFractionDigits;
    private final FastDateFormat fastDateFormat;
    private final char timeSeparatorChar;
    private final char millisSeparatorChar;
    private final int timeSeparatorLength;
    private final int millisSeparatorLength;
    private final FixedTimeZoneFormat fixedTimeZoneFormat;
    private volatile long midnightToday;
    private volatile long midnightTomorrow;
    private final int[] dstOffsets = new int[25];
    private char[] cachedDate;
    private int dateLength;
    static int[] TABLE = new int[]{100000, 10000, 1000, 100, 10, 1};

    FixedDateFormat(FixedFormat fixedFormat, TimeZone timeZone) {
        this(fixedFormat, timeZone, fixedFormat.getSecondFractionDigits());
    }

    FixedDateFormat(FixedFormat fixedFormat, TimeZone timeZone, int n2) {
        this.fixedFormat = Objects.requireNonNull(fixedFormat);
        this.timeZone = Objects.requireNonNull(timeZone);
        this.timeSeparatorChar = fixedFormat.timeSeparatorChar;
        this.timeSeparatorLength = fixedFormat.timeSeparatorLength;
        this.millisSeparatorChar = fixedFormat.millisSeparatorChar;
        this.millisSeparatorLength = fixedFormat.millisSeparatorLength;
        this.fixedTimeZoneFormat = fixedFormat.fixedTimeZoneFormat;
        this.length = fixedFormat.getLength();
        this.secondFractionDigits = Math.max(1, Math.min(9, n2));
        this.fastDateFormat = fixedFormat.getFastDateFormat(timeZone);
    }

    public static FixedDateFormat createIfSupported(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return new FixedDateFormat(FixedFormat.DEFAULT, TimeZone.getDefault());
        }
        TimeZone timeZone = stringArray.length > 1 ? (stringArray[1] != null ? TimeZone.getTimeZone(stringArray[1]) : TimeZone.getDefault()) : TimeZone.getDefault();
        String string = stringArray[0];
        FixedFormat fixedFormat = FixedFormat.lookupIgnoringNanos(string);
        if (fixedFormat != null) {
            int[] nArray = FixedFormat.nanoRange(string);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = n3 - n2;
            return new FixedDateFormat(fixedFormat, timeZone, n4);
        }
        FixedFormat fixedFormat2 = FixedFormat.lookup(string);
        return fixedFormat2 == null ? null : new FixedDateFormat(fixedFormat2, timeZone);
    }

    public static FixedDateFormat create(FixedFormat fixedFormat) {
        return new FixedDateFormat(fixedFormat, TimeZone.getDefault());
    }

    public static FixedDateFormat create(FixedFormat fixedFormat, TimeZone timeZone) {
        return new FixedDateFormat(fixedFormat, timeZone != null ? timeZone : TimeZone.getDefault());
    }

    public String getFormat() {
        return this.fixedFormat.getPattern();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public long millisSinceMidnight(long l2) {
        if (l2 >= this.midnightTomorrow || l2 < this.midnightToday) {
            this.updateMidnightMillis(l2);
        }
        return l2 - this.midnightToday;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMidnightMillis(long l2) {
        if (l2 >= this.midnightTomorrow || l2 < this.midnightToday) {
            FixedDateFormat fixedDateFormat = this;
            synchronized (fixedDateFormat) {
                this.updateCachedDate(l2);
                this.midnightToday = this.calcMidnightMillis(l2, 0);
                this.midnightTomorrow = this.calcMidnightMillis(l2, 1);
                this.updateDaylightSavingTime();
            }
        }
    }

    private long calcMidnightMillis(long l2, int n2) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(l2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, n2);
        return calendar.getTimeInMillis();
    }

    private void updateDaylightSavingTime() {
        Arrays.fill(this.dstOffsets, 0);
        int n2 = (int)TimeUnit.HOURS.toMillis(1L);
        if (this.timeZone.getOffset(this.midnightToday) != this.timeZone.getOffset(this.midnightToday + (long)(23 * n2))) {
            int n3;
            for (n3 = 0; n3 < this.dstOffsets.length; ++n3) {
                long l2 = this.midnightToday + (long)(n3 * n2);
                this.dstOffsets[n3] = this.timeZone.getOffset(l2) - this.timeZone.getRawOffset();
            }
            if (this.dstOffsets[0] > this.dstOffsets[23]) {
                n3 = this.dstOffsets.length - 1;
                while (n3 >= 0) {
                    int n4 = n3--;
                    this.dstOffsets[n4] = this.dstOffsets[n4] - this.dstOffsets[0];
                }
            }
        }
    }

    private void updateCachedDate(long l2) {
        if (this.fastDateFormat != null) {
            StringBuilder stringBuilder = this.fastDateFormat.format(l2, new StringBuilder());
            this.cachedDate = stringBuilder.toString().toCharArray();
            this.dateLength = stringBuilder.length();
        }
    }

    public String formatInstant(Instant instant) {
        char[] cArray = new char[this.length << 1];
        int n2 = this.formatInstant(instant, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public int formatInstant(Instant instant, char[] cArray, int n2) {
        long l2 = instant.getEpochMillisecond();
        int n3 = this.format(l2, cArray, n2);
        int n4 = this.formatNanoOfMillisecond(instant.getNanoOfMillisecond(), cArray, n2 + (n3 -= this.digitsLessThanThree()));
        return this.writeTimeZone(l2, cArray, n4);
    }

    private int digitsLessThanThree() {
        return Math.max(0, FixedFormat.MILLI_FRACTION_DIGITS - this.secondFractionDigits);
    }

    public String format(long l2) {
        char[] cArray = new char[this.length << 1];
        int n2 = this.format(l2, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public int format(long l2, char[] cArray, int n2) {
        int n3 = (int)this.millisSinceMidnight(l2);
        this.writeDate(cArray, n2);
        int n4 = this.writeTime(n3, cArray, n2 + this.dateLength);
        return n4 - n2;
    }

    private void writeDate(char[] cArray, int n2) {
        if (this.cachedDate != null) {
            System.arraycopy(this.cachedDate, 0, cArray, n2, this.dateLength);
        }
    }

    private int writeTime(int n2, char[] cArray, int n3) {
        int n4 = n2 / 3600000;
        int n5 = n4 + this.daylightSavingTime(n4) / 3600000;
        int n6 = (n2 -= 3600000 * n4) / 60000;
        int n7 = (n2 -= 60000 * n6) / 1000;
        n2 -= 1000 * n7;
        int n8 = n5 / 10;
        cArray[n3++] = (char)(n8 + 48);
        cArray[n3++] = (char)(n5 - 10 * n8 + 48);
        cArray[n3] = this.timeSeparatorChar;
        n3 += this.timeSeparatorLength;
        n8 = n6 / 10;
        cArray[n3++] = (char)(n8 + 48);
        cArray[n3++] = (char)(n6 - 10 * n8 + 48);
        cArray[n3] = this.timeSeparatorChar;
        n3 += this.timeSeparatorLength;
        n8 = n7 / 10;
        cArray[n3++] = (char)(n8 + 48);
        cArray[n3++] = (char)(n7 - 10 * n8 + 48);
        cArray[n3] = this.millisSeparatorChar;
        n3 += this.millisSeparatorLength;
        n8 = n2 / 100;
        cArray[n3++] = (char)(n8 + 48);
        n2 -= 100 * n8;
        n8 = n2 / 10;
        cArray[n3++] = (char)(n8 + 48);
        cArray[n3++] = (char)((n2 -= 10 * n8) + 48);
        return n3;
    }

    private int writeTimeZone(long l2, char[] cArray, int n2) {
        if (this.fixedTimeZoneFormat != null) {
            n2 = this.fixedTimeZoneFormat.write(this.timeZone.getOffset(l2), cArray, n2);
        }
        return n2;
    }

    private int formatNanoOfMillisecond(int n2, char[] cArray, int n3) {
        int n4 = n2;
        for (int i2 = 0; i2 < this.secondFractionDigits - FixedFormat.MILLI_FRACTION_DIGITS; ++i2) {
            int n5 = TABLE[i2];
            int n6 = n4 / n5;
            cArray[n3++] = (char)(n6 + 48);
            n4 -= n5 * n6;
        }
        return n3;
    }

    private int daylightSavingTime(int n2) {
        return n2 > 23 ? this.dstOffsets[23] : this.dstOffsets[n2];
    }

    public boolean isEquivalent(long l2, int n2, long l3, int n3) {
        if (l2 == l3) {
            if (this.secondFractionDigits <= 3) {
                return (long)n2 / 1000000L == (long)n3 / 1000000L;
            }
            return n2 == n3;
        }
        return false;
    }

    public static enum FixedTimeZoneFormat {
        HH('\u0000', false, 3),
        HHMM('\u0000', true, 5),
        HHCMM(':', true, 6);

        private final char timeSeparatorChar;
        private final int timeSeparatorCharLen;
        private final boolean useMinutes;
        private final int length;

        private FixedTimeZoneFormat() {
            this('\u0000', true, 4);
        }

        private FixedTimeZoneFormat(char c2, boolean bl2, int n3) {
            this.timeSeparatorChar = c2;
            this.timeSeparatorCharLen = c2 != '\u0000' ? 1 : 0;
            this.useMinutes = bl2;
            this.length = n3;
        }

        public int getLength() {
            return this.length;
        }

        private int write(int n2, char[] cArray, int n3) {
            cArray[n3++] = n2 < 0 ? 45 : 43;
            int n4 = Math.abs(n2);
            int n5 = n4 / 3600000;
            int n6 = n4 - 3600000 * n5;
            int n7 = n5 / 10;
            cArray[n3++] = (char)(n7 + 48);
            cArray[n3++] = (char)(n5 - 10 * n7 + 48);
            if (this.useMinutes) {
                cArray[n3] = this.timeSeparatorChar;
                n3 += this.timeSeparatorCharLen;
                int n8 = n6 / 60000;
                n6 -= 60000 * n8;
                n7 = n8 / 10;
                cArray[n3++] = (char)(n7 + 48);
                cArray[n3++] = (char)(n8 - 10 * n7 + 48);
            }
            return n3;
        }
    }

    public static enum FixedFormat {
        ABSOLUTE("HH:mm:ss,SSS", null, 0, ':', 1, ',', 1, 3, null),
        ABSOLUTE_MICROS("HH:mm:ss,nnnnnn", null, 0, ':', 1, ',', 1, 6, null),
        ABSOLUTE_NANOS("HH:mm:ss,nnnnnnnnn", null, 0, ':', 1, ',', 1, 9, null),
        ABSOLUTE_PERIOD("HH:mm:ss.SSS", null, 0, ':', 1, '.', 1, 3, null),
        COMPACT("yyyyMMddHHmmssSSS", "yyyyMMdd", 0, ' ', 0, ' ', 0, 3, null),
        DATE("dd MMM yyyy HH:mm:ss,SSS", "dd MMM yyyy ", 0, ':', 1, ',', 1, 3, null),
        DATE_PERIOD("dd MMM yyyy HH:mm:ss.SSS", "dd MMM yyyy ", 0, ':', 1, '.', 1, 3, null),
        DEFAULT("yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 3, null),
        DEFAULT_MICROS("yyyy-MM-dd HH:mm:ss,nnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 6, null),
        DEFAULT_NANOS("yyyy-MM-dd HH:mm:ss,nnnnnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 9, null),
        DEFAULT_PERIOD("yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd ", 0, ':', 1, '.', 1, 3, null),
        ISO8601_BASIC("yyyyMMdd'T'HHmmss,SSS", "yyyyMMdd'T'", 2, ' ', 0, ',', 1, 3, null),
        ISO8601_BASIC_PERIOD("yyyyMMdd'T'HHmmss.SSS", "yyyyMMdd'T'", 2, ' ', 0, '.', 1, 3, null),
        ISO8601("yyyy-MM-dd'T'HH:mm:ss,SSS", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, null),
        ISO8601_OFFSET_DATE_TIME_HH("yyyy-MM-dd'T'HH:mm:ss,SSSX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HH),
        ISO8601_OFFSET_DATE_TIME_HHMM("yyyy-MM-dd'T'HH:mm:ss,SSSXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HHMM),
        ISO8601_OFFSET_DATE_TIME_HHCMM("yyyy-MM-dd'T'HH:mm:ss,SSSXXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HHCMM),
        ISO8601_PERIOD("yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 3, null),
        ISO8601_PERIOD_MICROS("yyyy-MM-dd'T'HH:mm:ss.nnnnnn", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 6, null),
        US_MONTH_DAY_YEAR2_TIME("dd/MM/yy HH:mm:ss.SSS", "dd/MM/yy ", 0, ':', 1, '.', 1, 3, null),
        US_MONTH_DAY_YEAR4_TIME("dd/MM/yyyy HH:mm:ss.SSS", "dd/MM/yyyy ", 0, ':', 1, '.', 1, 3, null);

        private static final String DEFAULT_SECOND_FRACTION_PATTERN = "SSS";
        private static final int MILLI_FRACTION_DIGITS;
        private static final char SECOND_FRACTION_PATTERN = 'n';
        private final String pattern;
        private final String datePattern;
        private final int escapeCount;
        private final char timeSeparatorChar;
        private final int timeSeparatorLength;
        private final char millisSeparatorChar;
        private final int millisSeparatorLength;
        private final int secondFractionDigits;
        private final FixedTimeZoneFormat fixedTimeZoneFormat;
        private static final int[] EMPTY_RANGE;

        private FixedFormat(String string2, String string3, int n3, char c2, int n4, char c3, int n5, int n6, FixedTimeZoneFormat fixedTimeZoneFormat) {
            this.timeSeparatorChar = c2;
            this.timeSeparatorLength = n4;
            this.millisSeparatorChar = c3;
            this.millisSeparatorLength = n5;
            this.pattern = Objects.requireNonNull(string2);
            this.datePattern = string3;
            this.escapeCount = n3;
            this.secondFractionDigits = n6;
            this.fixedTimeZoneFormat = fixedTimeZoneFormat;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getDatePattern() {
            return this.datePattern;
        }

        public static FixedFormat lookup(String string) {
            for (FixedFormat fixedFormat : FixedFormat.values()) {
                if (!fixedFormat.name().equals(string) && !fixedFormat.getPattern().equals(string)) continue;
                return fixedFormat;
            }
            return null;
        }

        static FixedFormat lookupIgnoringNanos(String string) {
            int[] nArray = FixedFormat.nanoRange(string);
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 > 0) {
                String string2 = string.substring(0, n2) + DEFAULT_SECOND_FRACTION_PATTERN + string.substring(n3, string.length());
                for (FixedFormat fixedFormat : FixedFormat.values()) {
                    if (!fixedFormat.getPattern().equals(string2)) continue;
                    return fixedFormat;
                }
            }
            return null;
        }

        private static int[] nanoRange(String string) {
            int n2 = string.indexOf(110);
            int n3 = -1;
            if (n2 >= 0) {
                n3 = string.indexOf(90, n2);
                n3 = n3 < 0 ? string.indexOf(88, n2) : n3;
                n3 = n3 < 0 ? string.length() : n3;
                for (int i2 = n2 + 1; i2 < n3; ++i2) {
                    if (string.charAt(i2) == 'n') continue;
                    return EMPTY_RANGE;
                }
            }
            return new int[]{n2, n3};
        }

        public int getLength() {
            return this.pattern.length() - this.escapeCount;
        }

        public int getDatePatternLength() {
            return this.getDatePattern() == null ? 0 : this.getDatePattern().length() - this.escapeCount;
        }

        public FastDateFormat getFastDateFormat() {
            return this.getFastDateFormat(null);
        }

        public FastDateFormat getFastDateFormat(TimeZone timeZone) {
            return this.getDatePattern() == null ? null : FastDateFormat.getInstance(this.getDatePattern(), timeZone);
        }

        public int getSecondFractionDigits() {
            return this.secondFractionDigits;
        }

        public FixedTimeZoneFormat getFixedTimeZoneFormat() {
            return this.fixedTimeZoneFormat;
        }

        static {
            MILLI_FRACTION_DIGITS = DEFAULT_SECOND_FRACTION_PATTERN.length();
            EMPTY_RANGE = new int[]{-1, -1};
        }
    }
}

