/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.thirdparty.ohh.AbstractHistogram;
import com.contrastsecurity.thirdparty.ohh.Histogram;
import com.contrastsecurity.thirdparty.ohh.packedarray.PackedLongArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;

public class PackedHistogram
extends Histogram {
    private PackedLongArray packedCounts;

    @Override
    long getCountAtIndex(int n2) {
        return this.getCountAtNormalizedIndex(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength));
    }

    @Override
    long getCountAtNormalizedIndex(int n2) {
        long l2 = this.packedCounts.get(n2);
        return l2;
    }

    @Override
    void incrementCountAtIndex(int n2) {
        this.packedCounts.increment(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength));
    }

    @Override
    void addToCountAtIndex(int n2, long l2) {
        this.packedCounts.add(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength), l2);
    }

    @Override
    void setCountAtIndex(int n2, long l2) {
        this.setCountAtNormalizedIndex(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength), l2);
    }

    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        this.packedCounts.set(n2, l2);
    }

    @Override
    void clearCounts() {
        this.packedCounts.clear();
        this.packedCounts.setVirtualLength(this.countsArrayLength);
        this.totalCount = 0L;
    }

    @Override
    public PackedHistogram copy() {
        PackedHistogram packedHistogram = new PackedHistogram(this);
        packedHistogram.add(this);
        return packedHistogram;
    }

    @Override
    public PackedHistogram copyCorrectedForCoordinatedOmission(long l2) {
        PackedHistogram packedHistogram = new PackedHistogram(this);
        packedHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return packedHistogram;
    }

    @Override
    void resize(long l2) {
        int n2 = this.normalizeIndex(0, this.normalizingIndexOffset, this.countsArrayLength);
        int n3 = this.countsArrayLength;
        this.establishSize(l2);
        if (n2 != 0) {
            int n4;
            PackedLongArray packedLongArray = new PackedLongArray(this.countsArrayLength, this.packedCounts.getPhysicalLength());
            for (n4 = 0; n4 < n2; ++n4) {
                long l3 = this.packedCounts.get(n4);
                if (l3 == 0L) continue;
                packedLongArray.set(n4, l3);
            }
            n4 = this.countsArrayLength - n3;
            for (int i2 = n2; i2 < n3; ++i2) {
                long l4 = this.packedCounts.get(i2);
                if (l4 == 0L) continue;
                int n5 = i2 + n4;
                packedLongArray.set(n5, l4);
            }
            this.packedCounts = packedLongArray;
        } else {
            this.packedCounts.setVirtualLength(this.countsArrayLength);
        }
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 192 + 8 * this.packedCounts.getPhysicalLength();
    }

    public PackedHistogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public PackedHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public PackedHistogram(long l2, long l3, int n2) {
        super(l2, l3, n2, false);
        this.packedCounts = new PackedLongArray(this.countsArrayLength);
        this.wordSizeInBytes = 8;
    }

    public PackedHistogram(AbstractHistogram abstractHistogram) {
        super(abstractHistogram, false);
        this.packedCounts = new PackedLongArray(this.countsArrayLength);
        this.wordSizeInBytes = 8;
    }

    public static PackedHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return PackedHistogram.decodeFromByteBuffer(byteBuffer, PackedHistogram.class, l2);
    }

    public static PackedHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return PackedHistogram.decodeFromCompressedByteBuffer(byteBuffer, PackedHistogram.class, l2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

