/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.maps;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.ojt.maps.AbstractEntry;
import com.contrastsecurity.thirdparty.ojt.maps.ConcurrentAutoTable;
import com.contrastsecurity.thirdparty.ojt.maps.NonBlockingHashMap;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class NonBlockingHashMapLong<TypeV>
extends AbstractMap<Long, TypeV>
implements Serializable,
Cloneable,
ConcurrentMap<Long, TypeV> {
    private static final long serialVersionUID = 1234123412341234124L;
    private static final int REPROBE_LIMIT = 10;
    private static final int _Obase = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    private static final int _Oscale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
    private static final int _Lbase = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
    private static final int _Lscale = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
    private static final long _chm_offset = UnsafeAccess.fieldOffset(NonBlockingHashMapLong.class, "_chm");
    private static final long _val_1_offset = UnsafeAccess.fieldOffset(NonBlockingHashMapLong.class, "_val_1");
    private transient CHM _chm;
    private transient Object _val_1;
    private transient long _last_resize_milli;
    private final boolean _opt_for_space;
    private static final int MIN_SIZE_LOG = 4;
    private static final int MIN_SIZE = 16;
    private static final Object NO_MATCH_OLD = new Object();
    private static final Object MATCH_ANY = new Object();
    private static final Object TOMBSTONE = new Object();
    private static final Prime TOMBPRIME = new Prime(TOMBSTONE);
    private static final long NO_KEY = 0L;
    private transient ConcurrentAutoTable _reprobes = new ConcurrentAutoTable();

    private static long rawIndex(Object[] objectArray, int n2) {
        assert (n2 >= 0 && n2 < objectArray.length);
        return (long)_Obase + (long)n2 * (long)_Oscale;
    }

    private static long rawIndex(long[] lArray, int n2) {
        assert (n2 >= 0 && n2 < lArray.length);
        return (long)_Lbase + (long)n2 * (long)_Lscale;
    }

    private final boolean CAS(long l2, Object object, Object object2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, l2, object, object2);
    }

    public final void print() {
        System.out.println("=========");
        NonBlockingHashMapLong.print_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static void print_impl(int n2, long l2, Object object) {
        String string = object instanceof Prime ? "prime_" : "";
        Object object2 = Prime.unbox(object);
        String string2 = object2 == TOMBSTONE ? "tombstone" : object2.toString();
        System.out.println("[" + n2 + "]=(" + l2 + "," + string + string2 + ")");
    }

    private void print2() {
        System.out.println("=========");
        NonBlockingHashMapLong.print2_impl(-99, 0L, this._val_1);
        this._chm.print();
        System.out.println("=========");
    }

    private static void print2_impl(int n2, long l2, Object object) {
        if (object != null && Prime.unbox(object) != TOMBSTONE) {
            NonBlockingHashMapLong.print_impl(n2, l2, object);
        }
    }

    public long reprobes() {
        long l2 = this._reprobes.get();
        this._reprobes = new ConcurrentAutoTable();
        return l2;
    }

    private static int reprobe_limit(int n2) {
        return 10 + (n2 >> 4);
    }

    public NonBlockingHashMapLong() {
        this(16, true);
    }

    public NonBlockingHashMapLong(int n2) {
        this(n2, true);
    }

    public NonBlockingHashMapLong(boolean bl2) {
        this(1, bl2);
    }

    public NonBlockingHashMapLong(int n2, boolean bl2) {
        this._opt_for_space = bl2;
        this.initialize(n2);
    }

    private void initialize(int n2) {
        RangeUtil.checkPositiveOrZero(n2, "initial_sz");
        int n3 = 4;
        while (1 << n3 < n2) {
            ++n3;
        }
        this._chm = new CHM(this, new ConcurrentAutoTable(), n3);
        this._val_1 = TOMBSTONE;
        this._last_resize_milli = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (this._val_1 == TOMBSTONE ? 0 : 1) + this._chm.size();
    }

    public boolean containsKey(long l2) {
        return this.get(l2) != null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public TypeV put(long l2, TypeV TypeV) {
        return this.putIfMatch(l2, TypeV, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(long l2, TypeV TypeV) {
        return this.putIfMatch(l2, TypeV, TOMBSTONE);
    }

    public TypeV remove(long l2) {
        return this.putIfMatch(l2, TOMBSTONE, NO_MATCH_OLD);
    }

    public boolean remove(long l2, Object object) {
        return this.putIfMatch(l2, TOMBSTONE, object) == object;
    }

    @Override
    public TypeV replace(long l2, TypeV TypeV) {
        return this.putIfMatch(l2, TypeV, MATCH_ANY);
    }

    @Override
    public boolean replace(long l2, TypeV TypeV, TypeV TypeV2) {
        return this.putIfMatch(l2, TypeV2, TypeV) == TypeV;
    }

    private TypeV putIfMatch(long l2, Object object, Object object2) {
        if (object2 == null || object == null) {
            throw new NullPointerException();
        }
        if (l2 == 0L) {
            Object object3 = this._val_1;
            if ((object2 == NO_MATCH_OLD || object3 == object2 || object2 == MATCH_ANY && object3 != TOMBSTONE || object2.equals(object3)) && !this.CAS(_val_1_offset, object3, object)) {
                object3 = this._val_1;
            }
            return (TypeV)(object3 == TOMBSTONE ? null : object3);
        }
        Object object4 = this._chm.putIfMatch(l2, object, object2);
        assert (!(object4 instanceof Prime));
        assert (object4 != null);
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    @Override
    public void clear() {
        CHM cHM = new CHM(this, new ConcurrentAutoTable(), 4);
        while (!this.CAS(_chm_offset, this._chm, cHM)) {
        }
        this.CAS(_val_1_offset, this._val_1, TOMBSTONE);
    }

    public void clear(boolean bl2) {
        this._chm.clear();
        this.CAS(_val_1_offset, this._val_1, TOMBSTONE);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this._val_1) {
            return true;
        }
        for (TypeV TypeV : this.values()) {
            if (TypeV != object && !TypeV.equals(object)) continue;
            return true;
        }
        return false;
    }

    public final TypeV get(long l2) {
        if (l2 == 0L) {
            Object object = this._val_1;
            return (TypeV)(object == TOMBSTONE ? null : object);
        }
        Object object = this._chm.get_impl(l2);
        assert (!(object instanceof Prime));
        assert (object != TOMBSTONE);
        return (TypeV)object;
    }

    @Override
    public TypeV get(Object object) {
        return object instanceof Long ? (TypeV)this.get((Long)object) : null;
    }

    @Override
    public TypeV remove(Object object) {
        return object instanceof Long ? (TypeV)this.remove((Long)object) : null;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return object instanceof Long && this.remove((Long)object, object2);
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof Long && this.containsKey((Long)object);
    }

    @Override
    public TypeV putIfAbsent(Long l2, TypeV TypeV) {
        return this.putIfAbsent((long)l2, TypeV);
    }

    @Override
    public TypeV replace(Long l2, TypeV TypeV) {
        return this.replace((long)l2, TypeV);
    }

    @Override
    public TypeV put(Long l2, TypeV TypeV) {
        return this.put((long)l2, TypeV);
    }

    @Override
    public boolean replace(Long l2, TypeV TypeV, TypeV TypeV2) {
        return this.replace((long)l2, TypeV, TypeV2);
    }

    private void help_copy() {
        CHM cHM = this._chm;
        if (cHM._newchm == null) {
            return;
        }
        cHM.help_copy_impl(false);
    }

    private static final int hash(long l2) {
        l2 ^= l2 >>> 20 ^ l2 >>> 12;
        l2 ^= l2 >>> 7 ^ l2 >>> 4;
        l2 += l2 << 7;
        return (int)l2;
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMapLong.this.containsValue(object);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<Long> keys() {
        return new IteratorLong();
    }

    @Override
    public Set<Long> keySet() {
        return new AbstractSet<Long>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingHashMapLong.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return NonBlockingHashMapLong.this.remove(object) != null;
            }

            public IteratorLong iterator() {
                return new IteratorLong();
            }
        };
    }

    public long[] keySetLong() {
        long[] lArray = new long[this.size()];
        IteratorLong iteratorLong = (IteratorLong)this.keySet().iterator();
        int n2 = 0;
        while (n2 < lArray.length && iteratorLong.hasNext()) {
            lArray[n2++] = iteratorLong.nextLong();
        }
        return lArray;
    }

    @Override
    public Set<Map.Entry<Long, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<Long, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return NonBlockingHashMapLong.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object TypeV = NonBlockingHashMapLong.this.get(entry.getKey());
                return TypeV != null && TypeV.equals(entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<Long, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (long l2 : this.keySet()) {
            TypeV TypeV = this.get(l2);
            objectOutputStream.writeLong(l2);
            objectOutputStream.writeObject(TypeV);
        }
        objectOutputStream.writeLong(0L);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(16);
        while (true) {
            long l2 = objectInputStream.readLong();
            Object object = objectInputStream.readObject();
            if (l2 == 0L && object == null) break;
            this.put(l2, (TypeV)object);
        }
    }

    @Override
    public NonBlockingHashMapLong<TypeV> clone() {
        try {
            NonBlockingHashMapLong nonBlockingHashMapLong = (NonBlockingHashMapLong)super.clone();
            nonBlockingHashMapLong.clear();
            for (long l2 : this.keySetLong()) {
                nonBlockingHashMapLong.put(l2, this.get(l2));
            }
            return nonBlockingHashMapLong;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private class SnapshotE
    implements Iterator<Map.Entry<Long, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public Map.Entry<Long, TypeV> next() {
            this._ss.next();
            return new NBHMLEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMLEntry
    extends AbstractEntry<Long, TypeV> {
        NBHMLEntry(Long l2, TypeV TypeV) {
            super(l2, TypeV);
        }

        @Override
        public TypeV setValue(TypeV TypeV) {
            if (TypeV == null) {
                throw new NullPointerException();
            }
            this._val = TypeV;
            return NonBlockingHashMapLong.this.put((Long)this._key, TypeV);
        }
    }

    public class IteratorLong
    implements Enumeration<Long>,
    Iterator<Long> {
        private final SnapshotV _ss;

        public IteratorLong() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public Long next() {
            this._ss.next();
            return this._ss._prevK;
        }

        public long nextLong() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public Long nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotV
    implements Enumeration<TypeV>,
    Iterator<TypeV> {
        final CHM _sschm;
        private int _idx;
        private long _nextK;
        private long _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            CHM cHM;
            while (true) {
                cHM = NonBlockingHashMapLong.this._chm;
                if (cHM._newchm == null) break;
                cHM.help_copy_impl(true);
            }
            this._sschm = cHM;
            this._idx = -1;
            this.next();
        }

        int length() {
            return this._sschm._keys.length;
        }

        long key(int n2) {
            return this._sschm._keys[n2];
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != -1 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            if (this._idx == -1) {
                this._idx = 0;
                this._nextK = 0L;
                this._nextV = NonBlockingHashMapLong.this.get(this._nextK);
                if (this._nextV != null) {
                    return this._prevV;
                }
            }
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == 0L || (this._nextV = NonBlockingHashMapLong.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        public void removeKey() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            NonBlockingHashMapLong.this.putIfMatch(this._prevK, TOMBSTONE, NO_MATCH_OLD);
            this._prevV = null;
        }

        @Override
        public void remove() {
            this.removeKey();
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM
    implements Serializable {
        final NonBlockingHashMapLong _nbhml;
        private ConcurrentAutoTable _size;
        private ConcurrentAutoTable _slots;
        volatile CHM _newchm;
        private static final AtomicReferenceFieldUpdater<CHM, CHM> _newchmUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, CHM.class, "_newchm");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        final long[] _keys;
        final Object[] _vals;
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newchm(CHM cHM) {
            return _newchmUpdater.compareAndSet(this, null, cHM);
        }

        private boolean CAS_key(int n2, long l2, long l3) {
            return UnsafeAccess.UNSAFE.compareAndSwapLong(this._keys, NonBlockingHashMapLong.rawIndex(this._keys, n2), l2, l3);
        }

        private boolean CAS_val(int n2, Object object, Object object2) {
            return UnsafeAccess.UNSAFE.compareAndSwapObject(this._vals, NonBlockingHashMapLong.rawIndex(this._vals, n2), object, object2);
        }

        CHM(NonBlockingHashMapLong nonBlockingHashMapLong, ConcurrentAutoTable concurrentAutoTable, int n2) {
            this._nbhml = nonBlockingHashMapLong;
            this._size = concurrentAutoTable;
            this._slots = new ConcurrentAutoTable();
            this._keys = new long[1 << n2];
            this._vals = new Object[1 << n2];
        }

        void clear() {
            this._size = new ConcurrentAutoTable();
            this._slots = new ConcurrentAutoTable();
            Arrays.fill(this._keys, 0L);
            Arrays.fill(this._vals, null);
        }

        private void print() {
            for (int i2 = 0; i2 < this._keys.length; ++i2) {
                long l2 = this._keys[i2];
                if (l2 == 0L) continue;
                NonBlockingHashMapLong.print_impl(i2, l2, this._vals[i2]);
            }
            CHM cHM = this._newchm;
            if (cHM != null) {
                System.out.println("----");
                cHM.print();
            }
        }

        private void print2() {
            for (int i2 = 0; i2 < this._keys.length; ++i2) {
                long l2 = this._keys[i2];
                if (l2 == 0L) continue;
                NonBlockingHashMapLong.print2_impl(i2, l2, this._vals[i2]);
            }
            CHM cHM = this._newchm;
            if (cHM != null) {
                System.out.println("----");
                cHM.print2();
            }
        }

        private Object get_impl(long l2) {
            int n2 = NonBlockingHashMapLong.hash(l2);
            int n3 = this._keys.length;
            int n4 = n2 & n3 - 1;
            int n5 = 0;
            while (true) {
                long l3 = this._keys[n4];
                Object object = this._vals[n4];
                if (l3 == 0L) {
                    return null;
                }
                if (l2 == l3) {
                    if (!(object instanceof Prime)) {
                        if (object == TOMBSTONE) {
                            return null;
                        }
                        CHM cHM = this._newchm;
                        return object;
                    }
                    return this.copy_slot_and_check(n4, l2).get_impl(l2);
                }
                if (++n5 >= NonBlockingHashMapLong.reprobe_limit(n3)) {
                    return this._newchm == null ? null : this.copy_slot_and_check(n4, l2).get_impl(l2);
                }
                n4 = n4 + 1 & n3 - 1;
            }
        }

        private Object putIfMatch(long l2, Object object, Object object2) {
            Object object3;
            int n2 = NonBlockingHashMapLong.hash(l2);
            assert (object != null);
            assert (!(object instanceof Prime));
            assert (!(object2 instanceof Prime));
            int n3 = this._keys.length;
            int n4 = n2 & n3 - 1;
            int n5 = 0;
            while (true) {
                object3 = this._vals[n4];
                long l3 = this._keys[n4];
                if (l3 == 0L) {
                    if (object == TOMBSTONE) {
                        return TOMBSTONE;
                    }
                    if (object2 == MATCH_ANY) {
                        return TOMBSTONE;
                    }
                    if (this.CAS_key(n4, 0L, l2)) {
                        this._slots.add(1L);
                        break;
                    }
                    l3 = this._keys[n4];
                    assert (l3 != 0L);
                }
                if (l3 == l2) break;
                if (++n5 >= NonBlockingHashMapLong.reprobe_limit(n3)) {
                    CHM cHM = this.resize();
                    if (object2 != null) {
                        this._nbhml.help_copy();
                    }
                    return cHM.putIfMatch(l2, object, object2);
                }
                n4 = n4 + 1 & n3 - 1;
            }
            while (true) {
                if (object == object3) {
                    return object3;
                }
                if (object3 == null && this.tableFull(n5, n3) || object3 instanceof Prime) {
                    this.resize();
                    return this.copy_slot_and_check(n4, object2).putIfMatch(l2, object, object2);
                }
                if (!(object2 == NO_MATCH_OLD || object3 == object2 || object2 == MATCH_ANY && object3 != TOMBSTONE && object3 != null || object3 == null && object2 == TOMBSTONE || object2 != null && object2.equals(object3))) {
                    return object3 == null ? TOMBSTONE : object3;
                }
                if (this.CAS_val(n4, object3, object)) break;
                object3 = this._vals[n4];
                if (object3 instanceof Prime) {
                    return this.copy_slot_and_check(n4, object2).putIfMatch(l2, object, object2);
                }
                int n6 = NonBlockingHashMap.DUMMY_VOLATILE;
            }
            if (object2 != null) {
                if ((object3 == null || object3 == TOMBSTONE) && object != TOMBSTONE) {
                    this._size.add(1L);
                }
                if (object3 != null && object3 != TOMBSTONE && object == TOMBSTONE) {
                    this._size.add(-1L);
                }
            }
            return object3 == null && object2 != null ? TOMBSTONE : object3;
        }

        private boolean tableFull(int n2, int n3) {
            return n2 >= 10 && (n2 >= NonBlockingHashMapLong.reprobe_limit(n3) || this._slots.estimate_get() >= (long)(n3 >> 1));
        }

        private CHM resize() {
            int n2;
            CHM cHM = this._newchm;
            if (cHM != null) {
                return cHM;
            }
            int n3 = this._keys.length;
            int n4 = n2 = this.size();
            if (this._nbhml._opt_for_space) {
                if (n2 >= n3 >> 1) {
                    n4 = n3 << 1;
                }
            } else if (n2 >= n3 >> 2) {
                n4 = n3 << 1;
                if (n2 >= n3 >> 1) {
                    n4 = n3 << 2;
                }
            }
            long l2 = System.currentTimeMillis();
            if (n4 <= n3 && l2 <= this._nbhml._last_resize_milli + 10000L) {
                n4 = n3 << 1;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            int n5 = 4;
            while (1 << n5 < n4) {
                ++n5;
            }
            long l3 = (1L << n5 << 1) + 2L;
            if ((long)((int)l3) != l3 && (long)n2 > ((l3 = (1L << (n5 = 30)) + 2L) >> 2) + (l3 >> 1)) {
                throw new RuntimeException("Table is full.");
            }
            long l4 = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, l4, l4 + 1L)) {
                l4 = this._resizers;
            }
            long l5 = (1L << n5 << 1) + 8L << 3 >> 20;
            if (l4 >= 2L && l5 > 0L) {
                cHM = this._newchm;
                if (cHM != null) {
                    return cHM;
                }
                try {
                    Thread.sleep(l5);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                }
            }
            if ((cHM = this._newchm) != null) {
                return cHM;
            }
            cHM = new CHM(this._nbhml, this._size, n5);
            if (this._newchm != null) {
                return this._newchm;
            }
            if (!this.CAS_newchm(cHM)) {
                cHM = this._newchm;
            }
            return cHM;
        }

        private void help_copy_impl(boolean bl2) {
            CHM cHM = this._newchm;
            assert (cHM != null);
            int n2 = this._keys.length;
            int n3 = Math.min(n2, 1024);
            int n4 = -1;
            int n5 = -9999;
            while (this._copyDone < (long)n2) {
                if (n4 == -1) {
                    n5 = (int)this._copyIdx;
                    while (n5 < n2 << 1 && !_copyIdxUpdater.compareAndSet(this, n5, n5 + n3)) {
                        n5 = (int)this._copyIdx;
                    }
                    if (n5 >= n2 << 1) {
                        n4 = n5;
                    }
                }
                int n6 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!this.copy_slot(n5 + i2 & n2 - 1)) continue;
                    ++n6;
                }
                if (n6 > 0) {
                    this.copy_check_and_promote(n6);
                }
                n5 += n3;
                if (bl2 || n4 != -1) continue;
                return;
            }
            this.copy_check_and_promote(0);
        }

        private CHM copy_slot_and_check(int n2, Object object) {
            assert (this._newchm != null);
            if (this.copy_slot(n2)) {
                this.copy_check_and_promote(1);
            }
            if (object != null) {
                this._nbhml.help_copy();
            }
            return this._newchm;
        }

        private void copy_check_and_promote(int n2) {
            int n3 = this._keys.length;
            long l2 = this._copyDone;
            long l3 = l2 + (long)n2;
            assert (l3 <= (long)n3);
            if (n2 > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, l2, l3)) {
                    l2 = this._copyDone;
                    l3 = l2 + (long)n2;
                    assert (l3 <= (long)n3);
                }
            }
            if (l3 == (long)n3 && this._nbhml._chm == this && this._nbhml.CAS(_chm_offset, this, this._newchm)) {
                this._nbhml._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(int n2) {
            boolean bl2;
            Object object;
            long l2;
            while ((l2 = this._keys[n2]) == 0L) {
                this.CAS_key(n2, 0L, n2 + this._keys.length);
            }
            Object object2 = this._vals[n2];
            while (!(object2 instanceof Prime)) {
                Object object3 = object = object2 == null || object2 == TOMBSTONE ? TOMBPRIME : new Prime(object2);
                if (this.CAS_val(n2, object2, object)) {
                    if (object == TOMBPRIME) {
                        return true;
                    }
                    object2 = object;
                    break;
                }
                object2 = this._vals[n2];
            }
            if (object2 == TOMBPRIME) {
                return false;
            }
            object = ((Prime)object2)._V;
            assert (object != TOMBSTONE);
            boolean bl3 = bl2 = this._newchm.putIfMatch(l2, object, null) == null;
            while (object2 != TOMBPRIME && !this.CAS_val(n2, object2, TOMBPRIME)) {
                object2 = this._vals[n2];
            }
            return bl2;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object object) {
            this._V = object;
        }

        static Object unbox(Object object) {
            return object instanceof Prime ? ((Prime)object)._V : object;
        }
    }
}

