/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.ast;

import com.contrastsecurity.thirdparty.omv2.CompileException;
import com.contrastsecurity.thirdparty.omv2.MVEL;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.ast.ASTNode;
import com.contrastsecurity.thirdparty.omv2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Sign
extends ASTNode {
    private Signer signer;
    private ExecutableStatement stmt;

    public Sign(char[] cArray, int n2, int n3, int n4, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.start = n2 + 1;
        this.offset = n3 - 1;
        this.fields = n4;
        if ((n4 & 0x10) != 0) {
            this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(cArray, this.start, this.offset, parserContext);
            this.egressType = this.stmt.getKnownEgressType();
            if (this.egressType != null && this.egressType != Object.class) {
                this.initSigner(this.egressType);
            }
        }
    }

    public ExecutableStatement getStatement() {
        return this.stmt;
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return this.sign(this.stmt.getValue(object, object2, variableResolverFactory));
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return this.sign(MVEL.eval(this.expr, this.start, this.offset, object2, variableResolverFactory));
    }

    private Object sign(Object object) {
        if (object == null) {
            return null;
        }
        if (this.signer == null) {
            if (this.egressType == null || this.egressType == Object.class) {
                this.egressType = object.getClass();
            }
            this.initSigner(this.egressType);
        }
        return this.signer.sign(object);
    }

    private void initSigner(Class clazz) {
        if (Integer.class.isAssignableFrom(clazz = ParseTools.boxPrimitive(clazz))) {
            this.signer = new IntegerSigner();
        } else if (Double.class.isAssignableFrom(clazz)) {
            this.signer = new DoubleSigner();
        } else if (Long.class.isAssignableFrom(clazz)) {
            this.signer = new LongSigner();
        } else if (Float.class.isAssignableFrom(clazz)) {
            this.signer = new FloatSigner();
        } else if (Short.class.isAssignableFrom(clazz)) {
            this.signer = new ShortSigner();
        } else if (BigInteger.class.isAssignableFrom(clazz)) {
            this.signer = new BigIntSigner();
        } else if (BigDecimal.class.isAssignableFrom(clazz)) {
            this.signer = new BigDecSigner();
        } else {
            throw new CompileException("illegal use of '-': cannot be applied to: " + clazz.getName(), this.expr, this.start);
        }
    }

    public boolean isIdentifier() {
        return false;
    }

    private class BigDecSigner
    implements Signer {
        private BigDecSigner() {
        }

        public Object sign(Object object) {
            return new BigDecimal(-((BigDecimal)object).doubleValue());
        }
    }

    private class BigIntSigner
    implements Signer {
        private BigIntSigner() {
        }

        public Object sign(Object object) {
            return new BigInteger(String.valueOf(-((BigInteger)object).longValue()));
        }
    }

    private class FloatSigner
    implements Signer {
        private FloatSigner() {
        }

        public Object sign(Object object) {
            return Float.valueOf(-((Float)object).floatValue());
        }
    }

    private class DoubleSigner
    implements Signer {
        private DoubleSigner() {
        }

        public Object sign(Object object) {
            return -((Double)object).doubleValue();
        }
    }

    private class LongSigner
    implements Signer {
        private LongSigner() {
        }

        public Object sign(Object object) {
            return -((Long)object).longValue();
        }
    }

    private class ShortSigner
    implements Signer {
        private ShortSigner() {
        }

        public Object sign(Object object) {
            return (int)(-((Short)object).shortValue());
        }
    }

    private class IntegerSigner
    implements Signer {
        private IntegerSigner() {
        }

        public Object sign(Object object) {
            return -((Integer)object).intValue();
        }
    }

    private static interface Signer
    extends Serializable {
        public Object sign(Object var1);
    }
}

