/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import com.contrastsecurity.thirdparty.omv2.CompileException;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.ast.EndOfStatement;
import com.contrastsecurity.thirdparty.omv2.ast.Function;
import com.contrastsecurity.thirdparty.omv2.util.ExecutionStack;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;

public class FunctionParser {
    private String name;
    private int cursor;
    private int length;
    private int fields;
    private char[] expr;
    private ParserContext pCtx;
    private ExecutionStack splitAccumulator;

    public FunctionParser(String string, int n2, int n3, char[] cArray, int n4, ParserContext parserContext, ExecutionStack executionStack) {
        this.name = string;
        this.cursor = n2;
        this.length = n3;
        this.expr = cArray;
        this.fields = n4;
        this.pCtx = parserContext;
        this.splitAccumulator = executionStack;
    }

    public Function parse() {
        int n2;
        int n3;
        int n4 = this.cursor;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.cursor + this.length;
        this.cursor = ParseTools.captureToNextTokenJunction(this.expr, this.cursor, n7, this.pCtx);
        this.cursor = ParseTools.nextNonBlank(this.expr, this.cursor);
        if (this.expr[this.cursor] == '(') {
            n5 = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, n5, n7, '(', this.pCtx);
            n6 = this.cursor++;
            ++n5;
            this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            if (this.cursor >= n7) {
                throw new CompileException("incomplete statement", this.expr, this.cursor);
            }
            if (this.expr[this.cursor] == '{') {
                n3 = this.cursor;
                n2 = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, n3, n7, '{', this.pCtx);
            } else {
                n3 = this.cursor - 1;
                n2 = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, n7, this.pCtx);
            }
        } else if (this.expr[this.cursor] == '{') {
            n3 = this.cursor;
            n2 = this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, n3, n7, '{', this.pCtx);
        } else {
            n3 = this.cursor - 1;
            n2 = this.cursor = ParseTools.captureToEOS(this.expr, this.cursor, n7, this.pCtx);
        }
        n3 = ParseTools.trimRight(this.expr, n3 + 1);
        n2 = ParseTools.trimLeft(this.expr, n4, n2);
        ++this.cursor;
        if (this.splitAccumulator != null && ParseTools.isStatementNotManuallyTerminated(this.expr, this.cursor)) {
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
        return new Function(this.name, this.expr, n5, n6 - n5, n3, n2 - n3, this.fields, this.pCtx);
    }

    public String getName() {
        return this.name;
    }

    public int getCursor() {
        return this.cursor;
    }
}

