/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class LineMapper {
    private char[] expr;
    private ArrayList<Node> lineMapping;
    private Set<Integer> lines;

    public LineMapper(char[] cArray) {
        this.expr = cArray;
    }

    public LineLookup map() {
        int n2;
        this.lineMapping = new ArrayList();
        this.lines = new TreeSet<Integer>();
        int n3 = 0;
        int n4 = 1;
        for (n2 = 0; n2 < this.expr.length; ++n2) {
            switch (this.expr[n2]) {
                case '\n': {
                    this.lines.add(n4);
                    this.lineMapping.add(new Node(n3, n2, n4++));
                    n3 = n2 + 1;
                }
            }
        }
        if (n2 > n3) {
            this.lines.add(n4);
            this.lineMapping.add(new Node(n3, n2, n4));
        }
        return new LineLookup(){

            public int getLineFromCursor(int n2) {
                for (Node node : LineMapper.this.lineMapping) {
                    if (!node.isInRange(n2)) continue;
                    return node.getLine();
                }
                return -1;
            }

            public boolean hasLine(int n2) {
                return LineMapper.this.lines.contains(n2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable<Node> {
        private int cursorStart;
        private int cursorEnd;
        private int line;

        private Node(int n2, int n3, int n4) {
            this.cursorStart = n2;
            this.cursorEnd = n3;
            this.line = n4;
        }

        public int getLine() {
            return this.line;
        }

        public boolean isInRange(int n2) {
            return n2 >= this.cursorStart && n2 <= this.cursorEnd;
        }

        @Override
        public int compareTo(Node node) {
            if (node.cursorStart >= this.cursorEnd) {
                return 1;
            }
            if (node.cursorEnd < this.cursorStart) {
                return -1;
            }
            return 0;
        }
    }

    public static interface LineLookup {
        public int getLineFromCursor(int var1);

        public boolean hasLine(int var1);
    }
}

