/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import com.contrastsecurity.thirdparty.omv2.CompileException;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.ast.EndOfStatement;
import com.contrastsecurity.thirdparty.omv2.ast.Proto;
import com.contrastsecurity.thirdparty.omv2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.omv2.util.ExecutionStack;
import com.contrastsecurity.thirdparty.omv2.util.FunctionParser;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;

public class ProtoParser {
    private char[] expr;
    private ParserContext pCtx;
    private int endOffset;
    private int cursor;
    private String protoName;
    String tk1 = null;
    String tk2 = null;
    private Class type;
    private String name;
    private String deferredName;
    private boolean interpreted = false;
    private ExecutionStack splitAccumulator;
    private static ThreadLocal<Queue<DeferredTypeResolve>> deferred = new ThreadLocal();

    public ProtoParser(char[] cArray, int n2, int n3, String string, ParserContext parserContext, int n4, ExecutionStack executionStack) {
        this.expr = cArray;
        this.cursor = n2;
        this.endOffset = n3;
        this.protoName = string;
        this.pCtx = parserContext;
        this.interpreted = (0x10 & n4) == 0;
        this.splitAccumulator = executionStack;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Proto parse() {
        Proto proto = new Proto(this.protoName, this.pCtx);
        block8: while (this.cursor < this.endOffset) {
            Object object;
            int n2 = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            if (this.tk2 == null) {
                while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                    ++this.cursor;
                }
                if (this.cursor > n2) {
                    this.tk1 = new String(this.expr, n2, this.cursor - n2);
                    if ("def".equals(this.tk1) || "function".equals(this.tk1)) {
                        ++this.cursor;
                        n2 = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
                        while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                            ++this.cursor;
                        }
                        if (n2 == this.cursor) {
                            throw new CompileException("attempt to declare an anonymous function as a prototype member", this.expr, n2);
                        }
                        object = new FunctionParser(new String(this.expr, n2, this.cursor - n2), this.cursor, this.endOffset, this.expr, 0, this.pCtx, null);
                        proto.declareReceiver(((FunctionParser)object).getName(), ((FunctionParser)object).parse());
                        this.cursor = ((FunctionParser)object).getCursor() + 1;
                        this.tk1 = null;
                        continue;
                    }
                }
                this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            }
            if (this.cursor > this.endOffset) {
                throw new CompileException("unexpected end of statement in proto declaration: " + this.protoName, this.expr, n2);
            }
            switch (this.expr[this.cursor]) {
                case ';': {
                    ++this.cursor;
                    this.calculateDecl();
                    if (this.interpreted && this.type == DeferredTypeResolve.class) {
                        this.enqueueReceiverForLateResolution(this.deferredName, proto.declareReceiver(this.name, Proto.ReceiverType.DEFERRED, null), null);
                        continue block8;
                    }
                    proto.declareReceiver(this.name, this.type, null);
                    continue block8;
                }
                case '=': {
                    ++this.cursor;
                    n2 = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
                    block11: while (this.cursor < this.endOffset) {
                        switch (this.expr[this.cursor]) {
                            case '\"': 
                            case '\'': 
                            case '(': 
                            case '[': 
                            case '{': {
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.endOffset, this.expr[this.cursor], this.pCtx);
                                break;
                            }
                            case ';': {
                                break block11;
                            }
                        }
                        ++this.cursor;
                    }
                    this.calculateDecl();
                    object = new String(this.expr, n2, this.cursor++ - n2);
                    if (this.interpreted && this.type == DeferredTypeResolve.class) {
                        this.enqueueReceiverForLateResolution(this.deferredName, proto.declareReceiver(this.name, Proto.ReceiverType.DEFERRED, null), (String)object);
                        continue block8;
                    }
                    proto.declareReceiver(this.name, this.type, (ExecutableStatement)ParseTools.subCompileExpression((String)object, this.pCtx));
                    continue block8;
                }
            }
            n2 = this.cursor;
            while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                ++this.cursor;
            }
            if (this.cursor <= n2) continue;
            this.tk2 = new String(this.expr, n2, this.cursor - n2);
        }
        ++this.cursor;
        if (this.splitAccumulator != null && ParseTools.isStatementNotManuallyTerminated(this.expr, this.cursor)) {
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
        return proto;
    }

    private void calculateDecl() {
        if (this.tk2 != null) {
            try {
                this.type = this.pCtx.hasProtoImport(this.tk1) ? Proto.class : ParseTools.findClass(null, this.tk1, this.pCtx);
                this.name = this.tk2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.interpreted) {
                    this.type = DeferredTypeResolve.class;
                    this.deferredName = this.tk1;
                    this.name = this.tk2;
                }
                throw new CompileException("could not resolve class: " + this.tk1, this.expr, this.cursor, classNotFoundException);
            }
        } else {
            this.type = Object.class;
            this.name = this.tk1;
        }
        this.tk1 = null;
        this.tk2 = null;
    }

    private void enqueueReceiverForLateResolution(final String string, final Proto.Receiver receiver, final String string2) {
        Queue<DeferredTypeResolve> queue = deferred.get();
        if (queue == null) {
            queue = new LinkedList<DeferredTypeResolve>();
            deferred.set(queue);
        }
        queue.add(new DeferredTypeResolve(){

            public boolean isWaitingFor(Proto proto) {
                if (string.equals(proto.getName())) {
                    receiver.setType(Proto.ReceiverType.PROPERTY);
                    receiver.setInitValue((ExecutableStatement)ParseTools.subCompileExpression(string2, ProtoParser.this.pCtx));
                    return true;
                }
                return false;
            }

            public String getName() {
                return string;
            }
        });
    }

    public static void notifyForLateResolution(Proto proto) {
        if (deferred.get() != null) {
            Queue<DeferredTypeResolve> queue = deferred.get();
            HashSet<DeferredTypeResolve> hashSet = new HashSet<DeferredTypeResolve>();
            for (DeferredTypeResolve deferredTypeResolve : queue) {
                if (!deferredTypeResolve.isWaitingFor(proto)) continue;
                hashSet.add(deferredTypeResolve);
            }
            for (DeferredTypeResolve deferredTypeResolve : hashSet) {
                queue.remove(deferredTypeResolve);
            }
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public static void checkForPossibleUnresolvedViolations(char[] cArray, int n2, ParserContext parserContext) {
        LinkedHashMap linkedHashMap;
        Object object;
        if (ProtoParser.isUnresolvedWaiting() && (object = (linkedHashMap = (LinkedHashMap)parserContext.getParserConfiguration().getImports()).values().toArray()[linkedHashMap.size() - 1]) instanceof Proto) {
            Proto proto = (Proto)object;
            int n3 = proto.getCursorEnd();
            --n2;
            while (n2 > n3 && ParseTools.isWhitespace(cArray[n2])) {
                --n2;
            }
            while (n2 > n3 && ParseTools.isIdentifierPart(cArray[n2])) {
                --n2;
            }
            while (n2 > n3 && (ParseTools.isWhitespace(cArray[n2]) || cArray[n2] == ';')) {
                --n2;
            }
            if (n2 != n3) {
                throw new CompileException("unresolved reference (possible illegal forward-reference?): " + ProtoParser.getNextUnresolvedWaiting(), cArray, proto.getCursorStart());
            }
        }
    }

    public static boolean isUnresolvedWaiting() {
        return deferred.get() != null && !deferred.get().isEmpty();
    }

    public static String getNextUnresolvedWaiting() {
        if (deferred.get() != null && !deferred.get().isEmpty()) {
            return deferred.get().poll().getName();
        }
        return null;
    }

    private static interface DeferredTypeResolve {
        public boolean isWaitingFor(Proto var1);

        public String getName();
    }
}

