/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.os4j.helpers;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.os4j.helpers.FormattingTuple;
import com.contrastsecurity.thirdparty.os4j.helpers.Util;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String string, Object object) {
        return MessageFormatter.arrayFormat(string, new Object[]{object});
    }

    public static final FormattingTuple format(String string, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string, new Object[]{object, object2});
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        Object[] objectArray2 = objectArray;
        if (throwable != null) {
            objectArray2 = MessageFormatter.trimmedCopy(objectArray);
        }
        return MessageFormatter.arrayFormat(string, objectArray2, throwable);
    }

    public static final FormattingTuple arrayFormat(String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return new FormattingTuple(null, objectArray, throwable);
        }
        if (objectArray == null) {
            return new FormattingTuple(string);
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n3 = string.indexOf(DELIM_STR, n2);
            if (n3 == -1) {
                if (n2 == 0) {
                    return new FormattingTuple(string, objectArray, throwable);
                }
                stringBuilder.append(string, n2, string.length());
                return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(string, n3)) {
                if (!MessageFormatter.isDoubleEscaped(string, n3)) {
                    --i2;
                    stringBuilder.append(string, n2, n3 - 1);
                    stringBuilder.append('{');
                    n2 = n3 + 1;
                    continue;
                }
                stringBuilder.append(string, n2, n3 - 1);
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i2], new HashMap<Object[], Object>());
                n2 = n3 + 2;
                continue;
            }
            stringBuilder.append(string, n2, n3);
            MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i2], new HashMap<Object[], Object>());
            n2 = n3 + 2;
        }
        stringBuilder.append(string, n2, string.length());
        return new FormattingTuple(stringBuilder.toString(), objectArray, throwable);
    }

    static final boolean isEscapedDelimeter(String string, int n2) {
        if (n2 == 0) {
            return false;
        }
        char c2 = string.charAt(n2 - 1);
        return c2 == '\\';
    }

    static final boolean isDoubleEscaped(String string, int n2) {
        return n2 >= 2 && string.charAt(n2 - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder stringBuilder, Object object, Map<Object[], Object> map) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(stringBuilder, object);
        } else if (object instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(stringBuilder, (boolean[])object);
        } else if (object instanceof byte[]) {
            MessageFormatter.byteArrayAppend(stringBuilder, (byte[])object);
        } else if (object instanceof char[]) {
            MessageFormatter.charArrayAppend(stringBuilder, (char[])object);
        } else if (object instanceof short[]) {
            MessageFormatter.shortArrayAppend(stringBuilder, (short[])object);
        } else if (object instanceof int[]) {
            MessageFormatter.intArrayAppend(stringBuilder, (int[])object);
        } else if (object instanceof long[]) {
            MessageFormatter.longArrayAppend(stringBuilder, (long[])object);
        } else if (object instanceof float[]) {
            MessageFormatter.floatArrayAppend(stringBuilder, (float[])object);
        } else if (object instanceof double[]) {
            MessageFormatter.doubleArrayAppend(stringBuilder, (double[])object);
        } else {
            MessageFormatter.objectArrayAppend(stringBuilder, (Object[])object, map);
        }
    }

    private static void safeObjectAppend(StringBuilder stringBuilder, Object object) {
        try {
            String string = object.toString();
            stringBuilder.append(string);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            Util.report("SLF4J: Failed toString() invocation on an object of type [" + object.getClass().getName() + "]", throwable2);
            stringBuilder.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder stringBuilder, Object[] objectArray, Map<Object[], Object> map) {
        stringBuilder.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i2], map);
                if (i2 == n2 - 1) continue;
                stringBuilder.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuilder.append("...");
        }
        stringBuilder.append(']');
    }

    private static void booleanArrayAppend(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(blArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void byteArrayAppend(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(byArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void charArrayAppend(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(cArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void shortArrayAppend(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(sArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void intArrayAppend(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(nArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void longArrayAppend(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(lArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void floatArrayAppend(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(fArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void doubleArrayAppend(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(dArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Object object = objectArray[objectArray.length - 1];
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public static Object[] trimmedCopy(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int n2 = objectArray.length - 1;
        Object[] objectArray2 = new Object[n2];
        if (n2 > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        }
        return objectArray2;
    }
}

