/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@DontObfuscate
public final class Lists {
    public static <T> List<T> copy(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static <T> LinkedList<T> newLinkedList(Collection<? extends T> collection) {
        return new f<T>(collection);
    }

    public static <T> LinkedList<T> newLinkedList(T ... TArray) {
        return new f<T>(Arrays.asList(TArray));
    }

    public static <T> List<T> of() {
        return Collections.emptyList();
    }

    public static <T> List<T> of(T t2) {
        return Collections.singletonList(t2);
    }

    public static <T> List<T> of(T t2, T t3) {
        ArrayList<T> arrayList = new ArrayList<T>(2);
        arrayList.add(t2);
        arrayList.add(t3);
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> List<T> of(T t2, T t3, T t4) {
        ArrayList<T> arrayList = new ArrayList<T>(3);
        arrayList.add(t2);
        arrayList.add(t3);
        arrayList.add(t4);
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> List<T> of(T t2, T t3, T t4, T t5) {
        ArrayList<T> arrayList = new ArrayList<T>(4);
        arrayList.add(t2);
        arrayList.add(t3);
        arrayList.add(t4);
        arrayList.add(t5);
        return Collections.unmodifiableList(arrayList);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        arrayList.addAll(Arrays.asList(TArray));
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> List<T> of(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private Lists() {
    }

    @DontObfuscate
    public static final class Builder<T> {
        private List<T> list = new ArrayList<T>();

        private Builder() {
        }

        public Builder<T> add(T t2) {
            Preconditions.check(this.list != null, "This one-time-use list builder has already built a list.");
            this.list.add(Objects.requireNonNull(t2));
            return this;
        }

        public Builder<T> addAll(Collection<T> collection) {
            Preconditions.check(this.list != null, "This one-time-use list builder has already built a list.");
            this.list.addAll(Preconditions.checkNotEmpty(collection));
            return this;
        }

        public List<T> build() {
            Preconditions.check(this.list != null, "This one-time-use list builder has already built a list.");
            List<T> list = this.list;
            this.list = null;
            return Collections.unmodifiableList(list);
        }
    }
}

