/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.http.ContrastContentType;
import com.contrastsecurity.agent.http.HttpResponseReflector;
import com.contrastsecurity.agent.http.StandardHttpHeader;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public final class HttpResponse
extends c {
    public static int DEFAULT_BODY_SIZE_LIMIT = 524288;
    private HttpResponseReflector reflector;
    private int status = -1;
    private ContrastContentType frameworkContentType;
    private ContrastContentType cachedHeaderContentType;
    private String prevContentTypeHeader;
    private final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private final HttpResponseType httpResponseType;

    public HttpResponse(HttpResponseType httpResponseType, int n2, ContrastContentType contrastContentType) {
        super(c.a.b);
        this.httpResponseType = httpResponseType;
        this.status = n2;
        this.frameworkContentType = contrastContentType;
    }

    public HttpResponse(HttpResponseType httpResponseType, HttpResponseReflector httpResponseReflector) {
        super(c.a.b);
        this.httpResponseType = httpResponseType;
        this.reflector = httpResponseReflector;
    }

    public int getStatus() {
        if (this.status != -1) {
            return this.status;
        }
        int n2 = this.reflector.status();
        this.status = n2 < 100 ? -1 : n2;
        return this.status;
    }

    public ContrastContentType getContentType() {
        List<String> list = this.headers.get(StandardHttpHeader.CONTENT_TYPE.headerName());
        if (list == null) {
            return this.frameworkContentType();
        }
        String string = list.get(0);
        if (string == null) {
            return this.frameworkContentType();
        }
        if (string == this.prevContentTypeHeader) {
            return this.cachedHeaderContentType;
        }
        this.cachedHeaderContentType = ContrastContentType.parse(string);
        this.prevContentTypeHeader = string;
        return this.cachedHeaderContentType;
    }

    @Override
    public Charset getCharset() {
        return this.getContentType().getCharset();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpResponseDTM toHttpResponseDTM() {
        return HttpResponseDTM.builder().characterEncoding(this.getCharset().toString()).contentType(this.getContentType().getMimeType()).status(this.getStatus()).headers(this.getHeaders()).build();
    }

    public static boolean isOfType(HttpResponse httpResponse, HttpResponseType httpResponseType) {
        return httpResponse != null && httpResponse.httpResponseType == httpResponseType;
    }

    private ContrastContentType frameworkContentType() {
        return this.frameworkContentType != null ? this.frameworkContentType : this.reflector.frameworkContentType();
    }

    @DontObfuscate
    public static enum HttpResponseType {
        AKKA,
        GRIZZLY,
        J2EE,
        JDK,
        MULESOFT,
        NETTY,
        UNDERTOW,
        XENON;

    }
}

