/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.semconv.SemanticAttributes;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@DontObfuscate
@o
public final class SqlExecutionDispatcherImpl
implements ContrastObserveSqlExecutionDispatcher {
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private final Config config;
    private static final Logger logger = LoggerFactory.getLogger(SqlExecutionDispatcherImpl.class);

    public SqlExecutionDispatcherImpl(SqlDatabaseInfoCache sqlDatabaseInfoCache, Config config) {
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
        this.config = config;
    }

    public Object onExecuteStart(Object object, String string, Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return null;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "storage-query", string);
        return this.addSpanAttributes(span, object2);
    }

    private Span addSpanAttributes(Span span, Object object) {
        if (span == null) {
            return null;
        }
        try {
            Connection connection = ((Statement)object).getConnection();
            if (connection == null) {
                logger.debug("Got null connection from statement of type {}", (Object)object.getClass());
                return span;
            }
            DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
            if (dbInfo == null) {
                logger.debug("Could not get database info for connection of type {}", (Object)connection.getClass());
                return span;
            }
            if (dbInfo.name() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.name());
            } else if (dbInfo.db() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.db());
            }
            if (dbInfo.system() != null) {
                span.setAttribute(SemanticAttributes.DB_SYSTEM, dbInfo.system());
            }
            if (dbInfo.user() != null) {
                span.setAttribute(SemanticAttributes.DB_USER, dbInfo.user());
            }
            if (dbInfo.host() != null) {
                span.setAttribute(ContrastSemanticAttributes.SERVER_ADDRESS, dbInfo.host());
                if (dbInfo.port() != null) {
                    span.setAttribute(ContrastSemanticAttributes.SERVER_PORT, dbInfo.port());
                }
            }
        }
        catch (SQLException sQLException) {
            logger.debug("Unable to add span attributes because of SQL error", sQLException);
        }
        return span;
    }

    public void onActionEnd(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        d.a(this.config, object2, contrastContext.observe(), contrastContext.application().current(), "storage-query");
    }
}

