/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ApplicationExecutionContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.context.RequestContext;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.contrastapi_v1_0.StandardRequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.finding.FindingDTM;
import com.contrastsecurity.agent.messages.finding.trace.EntrypointType;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventPropertyDTM;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.AdaptiveOptimizationManager;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.services.ngreporting.ConfidenceLevel;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.l;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ObjectUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class Finding
extends h {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Application application;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Collection<e> listeners;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Config config;
    private final long hash;
    @HeapUsage.Deep
    private HttpRequest request;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private String ruleId;
    @HeapUsage.Deep
    private Trace trace;
    @HeapUsage.Deep
    private Map<PropertyKey, String> properties;
    @HeapUsage.Deep
    private String preflightData;
    @HeapUsage.Deep
    private ObservedRoute currentObservedRoute;
    private static final String TRACE = "TRACE";
    private static final Logger logger = LoggerFactory.getLogger(Finding.class);
    public static final int SOURCE_AND_TARGET_TRACE_VERSION = 1;
    public static final int SOURCE_TYPES_TRACE_VERSION = 2;
    public static final int ROUTE_COVERAGE_TRACE_VERSION = 4;
    private static final int TRACE_VERSION = 4;

    private Finding(Config config, Application application, String string, Trace trace, long l2, Collection<e> collection) {
        this.config = Objects.requireNonNull(config);
        this.application = Objects.requireNonNull(application);
        this.ruleId = Objects.requireNonNull(string);
        this.trace = Objects.requireNonNull(trace);
        this.hash = l2;
        this.listeners = ObjectUtils.defaultIfNull(collection, Collections.emptyList());
        if (StringUtils.isEmpty(trace.getRuleId())) {
            trace.setRuleId(string);
        }
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest httpRequest) {
        this.request = httpRequest;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String string) {
        this.ruleId = string;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    public Map<PropertyKey, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<PropertyKey, String> map) {
        this.properties = map;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    @Override
    public String getPayload() {
        return n.a(() -> ObjectShare.GSON.toJson(this.toDTM()));
    }

    @Override
    public RequestMethod getMethod() {
        return StandardRequestMethod.PUT;
    }

    @Override
    public String getURL() {
        return "/api/ng/traces";
    }

    @Override
    public String getShortDescription() {
        return "Trace " + this.ruleId + ": " + this.trace;
    }

    private boolean hasOnlyMultipartSources(Trace trace) {
        int n2 = 0;
        int n3 = 0;
        List<CodeEvent> list = trace.getEvents();
        if (list == null) {
            return false;
        }
        for (int i2 = 0; i2 < list.size() && n3 == 0; ++i2) {
            SourceNode sourceNode;
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent) || (sourceNode = ((SourceEvent)codeEvent).getSource()) == null) continue;
            boolean bl2 = sourceNode.isSourceType(u.f);
            if (bl2) {
                ++n2;
                continue;
            }
            ++n3;
        }
        return n2 > 0 && n3 == 0;
    }

    public FindingDTM toDTM() {
        Object object;
        SourceEvent sourceEvent;
        int n2 = this.hasOnlyMultipartSources(this.trace) ? 1 : 4;
        ApplicationExecutionContext applicationExecutionContext = this.application.context();
        String string = this.config.getOrNull(applicationExecutionContext, ConfigProperty.SESSION_ID);
        FindingDTM.Builder builder = FindingDTM.builder().setHash(this.getHash()).setRuleId(this.ruleId).setVersion(n2).setTags(this.config.getOrNull(applicationExecutionContext, ConfigProperty.ASSESS_TAGS)).setSessionId(string).setEvidence(this.trace.getEvidence()).setEvents(this.getLatestEventDTMs());
        if (this.properties == null) {
            this.properties = new EnumMap<PropertyKey, String>(PropertyKey.class);
        }
        if ((sourceEvent = this.trace.getFirstSourceEvent()) != null) {
            Object object2;
            object = sourceEvent.getQueue();
            if (object != null) {
                this.properties.put(PropertyKey.QUEUE_NAME, (String)object);
                this.properties.put(PropertyKey.ENTRYPOINT_TYPE, EntrypointType.MESSAGE_BROKER.toString());
                this.properties.put(PropertyKey.ENTRYPOINT_SIGNATURE, (String)object);
            }
            if ((object2 = Finding.getRequestContextValue(this.request, HttpRequest.PROCEDURE)) != null) {
                this.properties.put(PropertyKey.PROCEDURE_NAME, (String)object2);
                this.properties.put(PropertyKey.ENTRYPOINT_TYPE, EntrypointType.RPC.toString());
                this.properties.put(PropertyKey.ENTRYPOINT_SIGNATURE, (String)object2);
            }
        }
        if (this.request != null) {
            object = this.request.toHttpRequestDTM();
            builder.setRequest((HttpRequestDTM)object);
            this.request.getFrameworkInfo().ifPresent(frameworkInfo -> frameworkInfo.updateProperties(this.properties));
            if (this.trace.hasProperties()) {
                for (EventPropertyDTM eventPropertyDTM : this.trace.getPropertiesIterable()) {
                    this.properties.put(eventPropertyDTM.getKey(), eventPropertyDTM.getValue());
                }
            }
            if (this.currentObservedRoute == null) {
                this.currentObservedRoute = Finding.getRequestContextValue(this.request, RouteObservationProcessor.CURRENT_OBSERVED_ROUTE);
            }
            if (this.currentObservedRoute != null) {
                if (this.properties.get((Object)PropertyKey.ENTRYPOINT_TYPE) == null) {
                    this.properties.put(PropertyKey.ENTRYPOINT_TYPE, this.currentObservedRoute.type().toString());
                    this.properties.put(PropertyKey.ENTRYPOINT_SIGNATURE, this.currentObservedRoute.signature());
                }
                builder.setObservedRoute(this.currentObservedRoute);
            }
        }
        builder.setProperties(this.properties);
        return builder.build();
    }

    public boolean hasEvents() {
        List<CodeEvent> list = this.trace.getEvents();
        return list != null && !list.isEmpty();
    }

    private List<EventDTM> getLatestEventDTMs() {
        List<CodeEvent> list = this.trace.getEvents();
        ArrayList<EventDTM> arrayList = new ArrayList<EventDTM>(list.size());
        int n2 = this.trace.getLastTrigger();
        for (int i2 = 0; i2 <= n2 && i2 < list.size(); ++i2) {
            CodeEvent codeEvent = list.get(i2);
            try {
                EventDTM eventDTM = codeEvent.toDtm();
                arrayList.add(eventDTM);
                continue;
            }
            catch (l l2) {
                logger.error("Failed to convert CodeEvent to DTM.", l2);
            }
        }
        return arrayList;
    }

    @Override
    public ConfidenceLevel getLevel() {
        return this.trace.level;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getReportCode() {
        return TRACE;
    }

    @Override
    public boolean requiresPreflight() {
        return true;
    }

    @Override
    public String getPreflightData() {
        if (this.preflightData == null) {
            this.preflightData = this.ruleId + "," + this.getHash();
        }
        return this.preflightData;
    }

    @Override
    public String getContentType() {
        return com.contrastsecurity.agent.d.a.a.toString();
    }

    @Override
    public void onIgnoredAsAlreadyReported() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|LocalCacheHit|ruleId={}", "!LM!", "TraceFate", this.ruleId);
        }
    }

    @Override
    public void onAcceptedIntoReportingQueue() {
        this.fetchAndCacheRequestBody();
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|NewFinding|ruleId={}", "!LM!", "TraceFate", this.ruleId);
        }
        for (e e2 : this.listeners) {
            e2.a(this);
        }
    }

    private void fetchAndCacheRequestBody() {
        HttpRequest httpRequest = this.getRequest();
        if (httpRequest != null) {
            httpRequest.getBufferAsString();
        }
    }

    @Override
    public void onRejectedByPreflight() {
        if (logger.isTraceEnabled()) {
            logger.trace("{}{}|Preflighted|ruleId={}", "!LM!", "TraceFate", this.ruleId);
        }
    }

    private static <V> V getRequestContextValue(HttpRequest httpRequest, ExecutionContext.Key<V> key) {
        if (httpRequest == null) {
            return null;
        }
        RequestContext requestContext = httpRequest.context();
        return requestContext == null ? null : (V)requestContext.get(key);
    }

    public String toString() {
        return "Finding{hash=" + this.hash + ", ruleId='" + this.ruleId + '\'' + ", trace=" + this.trace + ", request=" + this.request + ", currentObservedRoute=" + this.currentObservedRoute + '}';
    }

    @HeapUsage.SupportsHeapProfiling
    static class f
    implements e {
        @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
        private final com.contrastsecurity.agent.o.c a;

        f(com.contrastsecurity.agent.o.c c2) {
            this.a = Objects.requireNonNull(c2);
        }

        @Override
        public void a(Finding finding) {
            this.a.a(finding);
        }
    }

    @HeapUsage.SupportsHeapProfiling
    static class a
    implements e {
        @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
        private final AdaptiveOptimizationManager a;

        a(AdaptiveOptimizationManager adaptiveOptimizationManager) {
            this.a = Objects.requireNonNull(adaptiveOptimizationManager);
        }

        @Override
        public void a(Finding finding) {
            Trace trace = finding.getTrace();
            if (trace == null) {
                return;
            }
            List<CodeEvent> list = trace.getEvents();
            if (list == null || list.isEmpty()) {
                return;
            }
            this.a.onTraceReported(finding);
        }
    }

    @HeapUsage.SupportsHeapProfiling
    static class b
    implements e {
        static final b a = new b();

        b() {
        }

        @Override
        public void a(Finding finding) {
            Trace trace = finding.getTrace();
            if (trace == null) {
                return;
            }
            List<CodeEvent> list = trace.getEvents();
            if (list == null || list.isEmpty()) {
                return;
            }
            this.a(list);
        }

        void a(List<CodeEvent> list) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                CodeEvent codeEvent = list.get(i2);
                codeEvent.prepareForReporting(list, i2);
            }
        }
    }

    public static interface e {
        public void a(Finding var1);
    }

    @o
    public static final class c
    implements d {
        private final Config a;
        private final Collection<e> b;

        public c(AdaptiveOptimizationManager adaptiveOptimizationManager, Config config, com.contrastsecurity.agent.o.c c2) {
            this.a = Objects.requireNonNull(config);
            Lists.Builder<b> builder = Lists.builder().add(com.contrastsecurity.agent.plugins.security.Finding$b.a).add((b)((Object)new a(adaptiveOptimizationManager))).add((b)((Object)new f(c2)));
            if (config.getBoolean(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES)) {
                builder.add((b)((Object)com.contrastsecurity.agent.test.integration.a.a));
            }
            this.b = builder.build();
        }

        @Override
        public Finding a(Application application, String string, Trace trace, long l2) {
            return new Finding(this.a, application, string, trace, l2, this.b);
        }
    }

    public static interface d {
        public Finding a(Application var1, String var2, Trace var3, long var4);
    }
}

