/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.application.ApplicationAssessSettings_v1_0DTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.application.ApplicationSettings_v1_0DTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.application.RegexValidator_v1_0DTM;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.apps.e;
import com.contrastsecurity.agent.plugins.apps.g;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@o
@DontObfuscate
public final class RegexSecurityControls
implements g {
    public static final ExecutionContext.Key<Map> KEY_REGEX_SECURITY_CONTROLS = ExecutionContext.Key.create(Map.class);
    public static final String REGEX_VALIDATOR_TYPE = "regex-validator";
    private static final Logger logger = LoggerFactory.getLogger(RegexSecurityControls.class);

    public static TagSetAndRuleString tagsForRegex(Application application, String string) {
        Map map = application.context().get(KEY_REGEX_SECURITY_CONTROLS);
        return map == null ? null : (TagSetAndRuleString)map.get(string);
    }

    public static boolean anyRegexs(ContrastContext contrastContext) {
        ApplicationContext applicationContext = contrastContext.application();
        Application application = applicationContext.current();
        if (application == null) {
            return false;
        }
        Map map = application.context().get(KEY_REGEX_SECURITY_CONTROLS);
        return map != null && !map.isEmpty();
    }

    @Override
    public void onApplicationSettingsUpdate(e e2) {
        Application application = e2.a();
        if (application == null) {
            return;
        }
        ApplicationSettings_v1_0DTM applicationSettings_v1_0DTM = e2.c();
        if (applicationSettings_v1_0DTM == null) {
            return;
        }
        ApplicationAssessSettings_v1_0DTM applicationAssessSettings_v1_0DTM = applicationSettings_v1_0DTM.getAssess();
        if (applicationAssessSettings_v1_0DTM == null) {
            return;
        }
        Set<RegexValidator_v1_0DTM> set = applicationAssessSettings_v1_0DTM.getRegexValidators();
        if (set == null) {
            return;
        }
        HashMap<String, TagSetAndRuleString> hashMap = new HashMap<String, TagSetAndRuleString>();
        for (RegexValidator_v1_0DTM regexValidator_v1_0DTM : set) {
            String string = regexValidator_v1_0DTM.getRegex();
            Set<String> set2 = regexValidator_v1_0DTM.getRules();
            if (string == null || set2 != null && set2.isEmpty()) continue;
            hashMap.put(string, TagSetAndRuleString.from(set2));
        }
        Map map = hashMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(hashMap);
        application.context().put(KEY_REGEX_SECURITY_CONTROLS, map);
    }

    @DontObfuscate
    public static final class TagSetAndRuleString {
        private final Set<Tag> tags;
        private final String rulesString;
        private static final TagSetAndRuleString ALL_RULES_INSTANCE = new TagSetAndRuleString(Collections.singleton(Tag.CUSTOM_VALIDATED), "all-rules");

        private TagSetAndRuleString(Set<Tag> set, String string) {
            this.tags = set;
            this.rulesString = string;
        }

        public static TagSetAndRuleString from(Set<String> set) {
            if (set == null) {
                return ALL_RULES_INSTANCE;
            }
            String string = set.toString();
            Set<Tag> set2 = TagSetAndRuleString.tagsFromRules(set);
            if (set2.isEmpty()) {
                logger.warn("Tried to generate Tags for Regex Validator, but invalid rules were provided from TS: {}", (Object)set);
                return null;
            }
            return new TagSetAndRuleString(set2, string);
        }

        public Set<Tag> tags() {
            return this.tags;
        }

        public String ruleString() {
            return this.rulesString;
        }

        private static Set<Tag> tagsFromRules(Collection<String> collection) {
            HashSet<Tag> hashSet = new HashSet<Tag>();
            for (String string : collection) {
                Tag tag = Tag.fromString("custom-validated-" + string);
                if (tag == null || Tag.CUSTOM_CATCH_ALL.equals((Object)tag)) continue;
                hashSet.add(tag);
            }
            return hashSet;
        }
    }
}

