/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.pool;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.e;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.pool.ObjectPoolFactory;
import com.contrastsecurity.agent.pool.Poolable;
import com.contrastsecurity.agent.q;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public final class ObjectPoolImpl<T>
implements ObjectPool<T> {
    private final Object lock = new Object();
    private final ObjectPoolFactory<T> factory;
    private final Clock clock;
    private final BlockingQueue<Poolable<T>> queue;
    private final long maxTtlNS;
    private final int maxSize;
    private int ownedObjects;

    public ObjectPoolImpl(ObjectPoolFactory<T> objectPoolFactory, Clock clock, int n2, Duration duration) {
        this(objectPoolFactory, clock, n2, duration, null);
    }

    @q
    ObjectPoolImpl(ObjectPoolFactory<T> objectPoolFactory, Clock clock, int n2, Duration duration, BlockingQueue<Poolable<T>> arrayBlockingQueue) {
        this.factory = Objects.requireNonNull(objectPoolFactory);
        this.clock = Objects.requireNonNull(clock);
        Preconditions.check(n2 >= 1, "Maximum size must be >= 1");
        this.maxSize = n2;
        Objects.requireNonNull(duration);
        Preconditions.check(!duration.isNegative() && !duration.isZero(), "Maximum TTL in NS must be > 0");
        this.maxTtlNS = duration.toNanos();
        this.queue = arrayBlockingQueue == null ? new ArrayBlockingQueue(n2) : arrayBlockingQueue;
    }

    @Override
    public Poolable<T> borrowObject() {
        try {
            Poolable<T> poolable = (Poolable<T>)this.queue.poll();
            if (poolable != null) {
                return poolable;
            }
            poolable = this.grow();
            return poolable != null ? poolable : this.queue.take();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            return this.createDisposable();
        }
        catch (InterruptedException interruptedException) {
            return this.createDisposable();
        }
    }

    @Override
    public Poolable<T> borrowObject(long l2, TimeUnit timeUnit) {
        try {
            Poolable<T> poolable = this.queue.poll(l2, timeUnit);
            if (poolable != null) {
                return poolable;
            }
            poolable = this.grow();
            return poolable != null ? poolable : this.createDisposable();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            return this.createDisposable();
        }
        catch (InterruptedException interruptedException) {
            return this.createDisposable();
        }
    }

    @Override
    public void returnObject(Poolable<T> poolable) throws InterruptedException {
        if (poolable.isDisposable()) {
            return;
        }
        poolable.updateLastAccess(this.clock);
        this.factory.reset(poolable.get());
        this.queue.put(poolable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public e purgeStale() {
        int n2 = this.queue.size();
        Object object = this.lock;
        synchronized (object) {
            this.queue.removeIf(poolable -> {
                if (poolable.hasExpired(this.clock)) {
                    this.factory.destroy(poolable.get());
                    --this.ownedObjects;
                    return true;
                }
                return false;
            });
        }
        return new e(n2, this.queue.size());
    }

    @Override
    public long getMaximumTTLinNS() {
        return this.maxTtlNS;
    }

    @Override
    public int idleCount() {
        return this.queue.size();
    }

    @Override
    public int activeCount() {
        return this.totalCount() - this.idleCount();
    }

    @Override
    public int totalCount() {
        return this.ownedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Poolable<T> grow() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.ownedObjects + 1 > this.maxSize) {
                return null;
            }
            ++this.ownedObjects;
            Poolable<T> poolable = Poolable.create(this, Objects.requireNonNull(this.factory.create()));
            poolable.updateLastAccess(this.clock);
            return poolable;
        }
    }

    @Override
    public Poolable<T> createDisposable() {
        Poolable<T> poolable = Poolable.createDisposable(this, Objects.requireNonNull(this.factory.create()));
        poolable.updateLastAccess(this.clock);
        return poolable;
    }
}

