/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.messages.app.ApplicationResponse;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.services.g;
import com.contrastsecurity.agent.services.ngreporting.ActivityReportContext;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.i;
import com.contrastsecurity.agent.services.ngreporting.m;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.cggl.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@o
public class a
extends m {
    private static final String b = "Contrast Application Activity Updater";
    private final long c;
    private final ApplicationSettingsUpdateEventBus d;
    private final f e;
    private final Clock f;
    private final PluginManager g;
    private static final Logger h = LoggerFactory.getLogger(a.class);

    public a(ApplicationManager applicationManager, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, Clock clock, Config config, f f2, PluginManager pluginManager, com.contrastsecurity.agent.telemetry.errors.o o2) {
        super(b, config.getLong(ConfigProperty.APP_ACTIVITY_PERIOD_MS), applicationManager, o2);
        this.d = applicationSettingsUpdateEventBus;
        this.f = clock;
        this.e = f2;
        this.g = pluginManager;
        this.c = config.getLong(ConfigProperty.STALE_APP_ACTIVITY_UPDATE_MS);
    }

    @Override
    void a(ContrastContext contrastContext) {
        h.debug("Spooling app activities...");
        for (Application application : ApplicationContext.all()) {
            this.b(application);
        }
    }

    private void b(Application application) {
        boolean bl2 = application.isUnwanted();
        boolean bl3 = application.getState().isCreated();
        if (bl2 || !bl3) {
            h.debug("Can't send app activity for {} - created on server = {}, wanted on server = {}", application, bl3, !bl2);
            return;
        }
        List<ContrastPlugin> list = this.g.getPlugins();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ActivityReportContext activityReportContext = new ActivityReportContext();
        this.a(application, list, hashMap, activityReportContext);
        boolean bl4 = this.a(application);
        if (!activityReportContext.isRequiresReport() && !bl4) {
            return;
        }
        h.debug("Sending app activity for {} - data needed to send = {}, stale = {}", application, activityReportContext.isRequiresReport(), bl4);
        i i2 = new i(hashMap, application, this.f);
        com.contrastsecurity.agent.e.g<String> g2 = this.a(application, i2);
        if (g2 == null) {
            h.debug("Didn't update settings for {}, response was null", (Object)application);
            return;
        }
        int n2 = g2.a();
        if (n2 == 409) {
            com.contrastsecurity.agent.services.g.a(application, n2, g2.b(), "app activity");
            return;
        }
        if (n2 != 200) {
            h.debug("Didn't update app settings for {}, status={}", (Object)application, (Object)n2);
            return;
        }
        String string = g2.b();
        if (StringUtils.isEmpty(string)) {
            h.debug("Didn't update app settings for {}, status={}", (Object)application, (Object)n2);
            return;
        }
        try {
            ApplicationResponse applicationResponse = ObjectShare.GSON.fromJson(string, ApplicationResponse.class);
            ApplicationSettingsDTM applicationSettingsDTM = applicationResponse.getSettings();
            if (applicationSettingsDTM == null) {
                return;
            }
            this.d.publish(application, applicationSettingsDTM, this.f.now());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            h.error("Encountered a JSON syntax error, unable to update application settings", jsonSyntaxException);
        }
    }

    private void a(Application application, List<ContrastPlugin> list, Map<String, Object> map, ActivityReportContext activityReportContext) {
        for (ContrastPlugin contrastPlugin : list) {
            try {
                contrastPlugin.onAppActivityReportingStarting(activityReportContext, application, map);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                h.error("Problem delegating activity report start event to {}", (Object)contrastPlugin, (Object)exception2);
            }
        }
    }

    private com.contrastsecurity.agent.e.g<String> a(Application application, LegacyReport legacyReport) {
        com.contrastsecurity.agent.e.g<String> g2 = this.e.b(legacyReport);
        application.setLastActivityReportedTime(this.f.now());
        return g2;
    }

    boolean a(Application application) {
        long l2 = application.getLastActivityReportedTime();
        if (l2 == 0L) {
            return true;
        }
        Date date = new Date(l2);
        long l3 = new Date(this.f.now()).getTime() - this.c;
        return date.before(new Date(l3));
    }
}

