/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry.metrics;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.metrics.MetricBuilder;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.e;
import com.contrastsecurity.agent.telemetry.metrics.f;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DontObfuscate
public interface DistributionSummary
extends f {
    public void record(double var1);

    public long count();

    public double totalAmount();

    public double mean();

    public double max();

    public e takeSnapshot();

    @q
    public static int decimalPlaces(double d2) {
        if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        if (d2 == Math.floor(d2)) {
            return 0;
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d2));
        return bigDecimal.scale();
    }

    @DontObfuscate
    public static class Builder
    implements MetricBuilder<DistributionSummary> {
        private final TelemetryMetrics metrics;
        private final String name;
        private final TelemetryMetrics.TelemetryCategory category;
        private final Map<String, String> tags;
        private String description;
        private String baseUnit;
        private double[] boundaries;
        private final a.a distStatisticConfigBuilder;
        private long expirationDate;

        public Builder(TelemetryMetrics telemetryMetrics, String string, TelemetryMetrics.TelemetryCategory telemetryCategory) {
            this.metrics = Objects.requireNonNull(telemetryMetrics);
            this.name = Preconditions.checkNotEmpty(string);
            this.category = Objects.requireNonNull(telemetryCategory);
            this.tags = new HashMap<String, String>(2);
            this.distStatisticConfigBuilder = new a.a();
            this.expirationDate = 7258118400000L;
        }

        public Builder withTag(String string, String string2) {
            this.tags.put(string, string2);
            return this;
        }

        @Override
        public Class<DistributionSummary> typeBuilt() {
            return DistributionSummary.class;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withBaseUnit(String string) {
            this.baseUnit = string;
            return this;
        }

        public Builder withBucketBoundaries(double ... dArray) {
            for (int i2 = 0; i2 < dArray.length - 1; ++i2) {
                if (!(dArray[i2] >= dArray[i2 + 1])) continue;
                throw new IllegalArgumentException("Bucket boundaries must be in increasing order. Found: " + dArray[i2] + " >= " + dArray[i2 + 1]);
            }
            for (double d2 : dArray) {
                if (Double.isNaN(d2)) {
                    throw new IllegalArgumentException("Bucket boundaries must not be NaN.");
                }
                if (d2 <= 0.0) {
                    throw new IllegalArgumentException("Bucket boundaries must be > 0.");
                }
                if (d2 != Double.POSITIVE_INFINITY) continue;
                throw new IllegalArgumentException("Bucket boundaries must not contain POSITIVE_INFINITY.");
            }
            int n2 = dArray.length;
            int n3 = 0;
            for (double d3 : dArray) {
                int n4 = DistributionSummary.decimalPlaces(d3);
                if (n4 > 3) {
                    throw new IllegalArgumentException("Bucket boundaries must have at most 3 decimal places, found: " + d3);
                }
                n3 = Math.max(n3, n4);
            }
            double[] dArray2 = Arrays.copyOf(dArray, n2 + 1);
            dArray2[n2] = Double.POSITIVE_INFINITY;
            this.boundaries = dArray2;
            if (n3 > 0) {
                double d4 = Math.pow(10.0, n3);
                this.distStatisticConfigBuilder.a(d4);
                for (int i3 = 0; i3 < this.boundaries.length - 1; ++i3) {
                    this.boundaries[i3] = this.boundaries[i3] * d4;
                    if (this.boundaries[i3] != Double.POSITIVE_INFINITY) continue;
                    throw new IllegalArgumentException("Bucket boundaries must not be POSITIVE_INFINITY after scaling.");
                }
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public TelemetryMetrics.TelemetryCategory getCategory() {
            return this.category;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public Map<String, String> getTags() {
            return this.tags;
        }

        public long getExpirationTimeMs() {
            return this.expirationDate;
        }

        public double[] getBucketBoundaries() {
            return (double[])this.boundaries.clone();
        }

        public int getNumberOfBuckets() {
            return this.boundaries.length;
        }

        public a getDistributionStatisticConfig() {
            return this.distStatisticConfigBuilder.a();
        }

        public Builder withExpiration(LocalDate localDate) {
            this.expirationDate = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            return this;
        }

        @q
        public Builder withExpirationTimeMs(long l2) {
            this.expirationDate = l2;
            return this;
        }

        public Builder withScale(double d2) {
            this.distStatisticConfigBuilder.a(d2);
            return this;
        }

        private Builder withPercentiles(double ... dArray) {
            this.distStatisticConfigBuilder.a(dArray);
            return this;
        }

        @Override
        public DistributionSummary register(TelemetryMetrics telemetryMetrics) {
            if (this.boundaries == null) {
                throw new IllegalArgumentException("Bucket Boundaries must be configured.");
            }
            return telemetryMetrics.register(this);
        }

        @Override
        public DistributionSummary register() {
            return this.register(this.metrics);
        }
    }
}

