/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.test.integration;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.application.ApplicationSettings_v1_0DTM;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.AdaptiveOptimizationManager;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.w;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.test.integration.a;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ObjectUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@DontObfuscate
public final class IntegrationTestServices {
    public static final String X_CONTRAST_INTEGRATION_TEST_HEADER = "x-contrast-integration-test";
    private final Config config;
    private final Clock clock;
    private final WorkingDirectories workingDirectories;
    private final Instrumentation instrumentation;
    private final ThreadLocal<Long> threadContextId = new ThreadLocal();
    private final Map<String, Set<DiscoveredRoute>> appDiscoveredRoutesMap = new ConcurrentHashMap<String, Set<DiscoveredRoute>>();
    private final Map<String, ObservedRoute> observedRoutes = new ConcurrentHashMap<String, ObservedRoute>();
    private final AdaptiveOptimizationManager adaptiveOptimizationManager;
    private final ApplicationManager applicationManager;
    private final ContrastPolicyManager policyManager;
    private final HttpManager httpManager;
    private final ObserveRootSpanManager rootSpanManager;
    private final AssessmentManager assessmentManager;
    private final ProtectManager protectManager;
    private final EventContext eventContext;
    private final OtelGlobalConfig otelGlobalConfig;
    private final ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus;
    private final PluginManager pluginManager;
    private static final Map<String, Boolean> ON_REQUEST_END_MAP = new ConcurrentHashMap<String, Boolean>();
    private static volatile IntegrationTestServices instance;
    private static final AtomicLong THREAD_ID_GENERATOR;

    public IntegrationTestServices(Config config, Clock clock, WorkingDirectories workingDirectories, Instrumentation instrumentation, AdaptiveOptimizationManager adaptiveOptimizationManager, ApplicationManager applicationManager, AssessmentManager assessmentManager, ContrastPolicyManager contrastPolicyManager, ProtectManager protectManager, EventContext eventContext, HttpManager httpManager, ObserveRootSpanManager observeRootSpanManager, OtelGlobalConfig otelGlobalConfig, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, PluginManager pluginManager) {
        this.config = config;
        this.clock = clock;
        this.workingDirectories = workingDirectories;
        this.adaptiveOptimizationManager = adaptiveOptimizationManager;
        this.policyManager = contrastPolicyManager;
        this.instrumentation = instrumentation;
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.rootSpanManager = observeRootSpanManager;
        this.assessmentManager = assessmentManager;
        this.protectManager = protectManager;
        this.eventContext = eventContext;
        this.otelGlobalConfig = otelGlobalConfig;
        this.applicationSettingsUpdateEventBus = applicationSettingsUpdateEventBus;
        this.pluginManager = pluginManager;
    }

    public static boolean isEnabled() {
        return instance != null;
    }

    public void updateSettings(ApplicationSettingsDTM applicationSettingsDTM) {
        this.updateSettings(ContrastContext.current().application().current(), applicationSettingsDTM);
    }

    public void updateSettings(Application application, ApplicationSettingsDTM applicationSettingsDTM) {
        this.applicationSettingsUpdateEventBus.publish(application, applicationSettingsDTM, this.clock.now());
    }

    public void updateSettings(ApplicationSettings_v1_0DTM applicationSettings_v1_0DTM) {
        this.applicationSettingsUpdateEventBus.publish(ContrastContext.current().application().current(), applicationSettings_v1_0DTM, this.clock.now());
    }

    public ThreadLocal<Long> threadContextId() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.threadContextId;
    }

    public OtelGlobalConfig otelGlobalConfig() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.otelGlobalConfig;
    }

    public ObserveRootSpanManager rootSpanManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.rootSpanManager;
    }

    public EventContext eventContext() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.eventContext;
    }

    public Config config() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.config;
    }

    public WorkingDirectories workingDirectories() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.workingDirectories;
    }

    public Instrumentation instrumentation() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.instrumentation;
    }

    public AssessmentManager assess() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.assessmentManager;
    }

    public ProtectManager protect() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.protectManager;
    }

    public AdaptiveOptimizationManager adaptiveOptimizationManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.adaptiveOptimizationManager;
    }

    public ApplicationManager applicationManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.applicationManager;
    }

    public HttpManager httpManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.httpManager;
    }

    public ContrastPolicyManager policyManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.policyManager;
    }

    public PluginManager pluginManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.pluginManager;
    }

    public static long newThreadContextId() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        long l2 = THREAD_ID_GENERATOR.incrementAndGet();
        IntegrationTestServices.instance.threadContextId.set(l2);
        return l2;
    }

    public static long currentThreadContextId() {
        if (instance == null) {
            return Long.MIN_VALUE;
        }
        Long l2 = IntegrationTestServices.instance.threadContextId.get();
        return l2 == null ? Long.MIN_VALUE : l2;
    }

    public void addDiscoveredRoutes(Collection<DiscoveredRoute> collection, Application application) {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        this.appDiscoveredRoutesMap.compute(application.getName(), (string, set) -> {
            HashSet hashSet = new HashSet(collection);
            if (set == null) {
                return hashSet;
            }
            hashSet.addAll(set);
            return hashSet;
        });
    }

    public void addObservedRoute(String string, ObservedRoute observedRoute) {
        this.observedRoutes.put(string, observedRoute);
    }

    public Collection<Finding> findings(String string) {
        return a.a.a(string);
    }

    public Collection<Finding> clearFindings(String string) {
        return a.a.b(string);
    }

    public Collection<DiscoveredRoute> getDiscoveredRoutes(Application application, Duration duration) throws InterruptedException {
        return this.getFromMapWithTimeout(this.appDiscoveredRoutesMap, application.getName(), duration);
    }

    public ObservedRoute getObservedRoute(String string, Duration duration) throws InterruptedException {
        return this.getFromMapWithTimeout(this.observedRoutes, string, duration);
    }

    public void onRequestEnd(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return;
        }
        String string = httpRequest.getHeader(X_CONTRAST_INTEGRATION_TEST_HEADER);
        if (StringUtils.isNotEmpty(string)) {
            ON_REQUEST_END_MAP.put(string, true);
        }
    }

    public boolean clearEndedRequest(String string) {
        return ObjectUtils.defaultIfNull(ON_REQUEST_END_MAP.remove(string), false);
    }

    private <A> A getFromMapWithTimeout(Map<String, A> map, String string, Duration duration) throws InterruptedException {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        long l2 = duration.toMillis();
        int n2 = 0;
        while ((long)n2 < l2) {
            A a2 = map.get(string);
            if (a2 != null) {
                return a2;
            }
            Thread.sleep(1000L);
            n2 += 1000;
        }
        return map.get(string);
    }

    public static IntegrationTestServices getInstance() {
        if (instance == null) {
            throw new IllegalStateException(IntegrationTestServices.class.getSimpleName() + " is not available in production.");
        }
        return instance;
    }

    static {
        THREAD_ID_GENERATOR = new AtomicLong(Long.MIN_VALUE);
    }

    @DontObfuscate
    public static final class StartupTask
    implements x {
        private final Config config;
        private final Clock clock;
        private final WorkingDirectories workingDirectories;
        private final Instrumentation instrumentation;
        private final AdaptiveOptimizationManager adaptiveOptimizationManager;
        private final ApplicationManager applicationManager;
        private final ContrastPolicyManager policyManager;
        private final HttpManager httpManager;
        private final ObserveRootSpanManager rootSpanManager;
        private final AssessmentManager assessmentManager;
        private final ProtectManager protectManager;
        private final EventContext eventContext;
        private final OtelGlobalConfig otelGlobalConfig;
        private final ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus;
        private final PluginManager pluginManager;

        public StartupTask(Config config, Clock clock, WorkingDirectories workingDirectories, Instrumentation instrumentation, AdaptiveOptimizationManager adaptiveOptimizationManager, ApplicationManager applicationManager, AssessmentManager assessmentManager, ContrastPolicyManager contrastPolicyManager, ProtectManager protectManager, EventContext eventContext, HttpManager httpManager, ObserveRootSpanManager observeRootSpanManager, OtelGlobalConfig otelGlobalConfig, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, PluginManager pluginManager) {
            this.config = config;
            this.clock = clock;
            this.workingDirectories = workingDirectories;
            this.instrumentation = instrumentation;
            this.adaptiveOptimizationManager = adaptiveOptimizationManager;
            this.applicationManager = applicationManager;
            this.assessmentManager = assessmentManager;
            this.policyManager = contrastPolicyManager;
            this.protectManager = protectManager;
            this.eventContext = eventContext;
            this.httpManager = httpManager;
            this.rootSpanManager = observeRootSpanManager;
            this.otelGlobalConfig = otelGlobalConfig;
            this.applicationSettingsUpdateEventBus = applicationSettingsUpdateEventBus;
            this.pluginManager = pluginManager;
        }

        @Override
        public void onStartupBegin(w w2) throws FatalStartupException {
            Logger logger = LoggerFactory.getLogger(IntegrationTestServices.class);
            if (this.config.getBoolean(ConfigProperty.NOTEAMSERVER_ENABLE) && !Assert.ENABLED) {
                logger.warn("NOTEAMSERVER_ENABLE is enabled without assertions enabled. If this is an automated test, please enable assertions with -D{}=true.", (Object)Assert.ENABLED_PROPERTY_NAME);
            }
            if (!this.config.getBoolean(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES)) {
                return;
            }
            if (!Assert.ENABLED) {
                AssertionError assertionError = new AssertionError((Object)("Contrast assertions must be enabled (-D" + Assert.ENABLED_PROPERTY_NAME + "=true) when ENABLE_INTEGRATION_TEST_SERVICES is enabled."));
                throw assertionError;
            }
            instance = new IntegrationTestServices(this.config, this.clock, this.workingDirectories, this.instrumentation, this.adaptiveOptimizationManager, this.applicationManager, this.assessmentManager, this.policyManager, this.protectManager, this.eventContext, this.httpManager, this.rootSpanManager, this.otelGlobalConfig, this.applicationSettingsUpdateEventBus, this.pluginManager);
        }

        @Override
        public String getTaskName() {
            return "integrationTestServices";
        }
    }
}

