/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.util.F;
import com.contrastsecurity.agent.util.FileUtil;
import com.contrastsecurity.agent.util.z;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

@DontObfuscate
public final class CpuInfo {
    private final double availableCpus;
    private final double effectiveCpus;
    private final double cpuLimit;
    private final AtomicReference<Throwable> configurationException;

    @q
    public CpuInfo(double d2, double d3, Throwable throwable) {
        this.availableCpus = d2;
        this.effectiveCpus = d3;
        this.cpuLimit = !Double.isNaN(d3) ? Math.min(d2, d3) : d2;
        this.configurationException = new AtomicReference<Throwable>(throwable);
    }

    public double cpuLimit() {
        return this.cpuLimit;
    }

    public double availableCpus() {
        return this.availableCpus;
    }

    public double effectiveCpus() {
        return this.effectiveCpus;
    }

    public static CpuInfo detectAvailableCpus() {
        return System.getSecurityManager() == null ? CpuInfo._detectAvailableCpus() : n.a(CpuInfo::_detectAvailableCpus);
    }

    private static CpuInfo _detectAvailableCpus() {
        double d2 = Runtime.getRuntime().availableProcessors();
        Throwable throwable = null;
        double d3 = Double.NaN;
        if (z.a.b == z.b) {
            try {
                d3 = CpuInfo.getEffectiveAvailableCpusForContainer();
            }
            catch (ConfigurationException configurationException) {
                throwable = configurationException;
            }
            catch (Throwable throwable2) {
                Throwables.throwIfCritical(throwable2);
                Throwable throwable3 = throwable2;
                Assert.fail("Unexpected error occurred when detecting effective CPUs.", throwable3);
                throwable = throwable3;
            }
        }
        return new CpuInfo(d2, d3, throwable);
    }

    private static double getEffectiveAvailableCpusForContainer() throws ConfigurationException {
        try {
            return CpuInfo.getCpuCountFromCGroupV2(new File("/sys/fs/cgroup/cpu.max"), new File("/sys/fs/cgroup/cpuset.cpus.effective"));
        }
        catch (ConfigurationException configurationException) {
            try {
                return CpuInfo.getCpuCountFromCGroupV1(new File("/sys/fs/cgroup/cpu/cpu.cfs_quota_us"), new File("/sys/fs/cgroup/cpu/cpu.cfs_period_us"), new File("/sys/fs/cgroup/cpuset/cpuset.cpus"));
            }
            catch (ConfigurationException configurationException2) {
                configurationException.addSuppressed(configurationException2);
                throw configurationException;
            }
        }
    }

    @q
    static double getCpuCountFromCGroupV1(File file, File file2, File file3) throws ConfigurationException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(file2);
        Objects.requireNonNull(file3);
        String string = CpuInfo.safeRead(file);
        if (!StringUtils.startsWith(string, "-")) {
            return CpuInfo.calculateEffectiveCpus(string, CpuInfo.safeRead(file2), Lists.of(file, file2));
        }
        return CpuInfo.getCpusFromCpuSet(file3);
    }

    private static double calculateEffectiveCpus(String string, String string2, List<File> list) throws ConfigurationException {
        NumberFormatException numberFormatException = null;
        try {
            double d2;
            double d3 = Double.parseDouble(string);
            double d4 = Double.parseDouble(string2);
            if (Double.isFinite(d3) && d3 > 0.0 && Double.isFinite(d4) && d4 > 0.0 && !Double.isNaN(d2 = d3 / d4)) {
                return d2;
            }
        }
        catch (NumberFormatException numberFormatException2) {
            numberFormatException = numberFormatException2;
        }
        throw new ConfigurationException("Failed to parse CPU quota \"" + string + "\" and/or CPU period \"" + string2 + "\" as positive double from: " + StringUtils.join(list, ","), numberFormatException);
    }

    @q
    static double getCpuCountFromCGroupV2(File file, File file2) throws ConfigurationException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(file2);
        String string = CpuInfo.safeRead(file);
        String string2 = null;
        String string3 = null;
        String[] stringArray = StringUtils.split(string);
        if (stringArray.length == 2) {
            string2 = StringUtils.trimToNull(stringArray[0]);
            string3 = StringUtils.trimToNull(stringArray[1]);
        }
        if (string2 == null || string3 == null) {
            throw new ConfigurationException(file.getAbsolutePath() + " did not contain CPU quota and period.");
        }
        if (!"max".equals(string2)) {
            return CpuInfo.calculateEffectiveCpus(string2, string3, Lists.of(file));
        }
        return CpuInfo.getCpusFromCpuSet(file2);
    }

    @q
    static int getCpusFromCpuSet(File file) throws ConfigurationException {
        int n2 = 0;
        String string = CpuInfo.safeRead(file);
        a a2 = new a(string);
        while (!a2.a()) {
            a2.a(F.a.a);
            a2.a(',');
            a2.a(F.a.a);
            long l2 = a2.b();
            if (l2 < 0L) {
                n2 = -1;
                break;
            }
            a2.a(F.a.a);
            if (a2.a('-')) {
                a2.a(F.a.a);
                long l3 = a2.b();
                if (l2 > l3) {
                    n2 = -1;
                    break;
                }
                n2 = (int)((long)n2 + (l3 - l2 + 1L));
                continue;
            }
            ++n2;
        }
        if (n2 <= 0) {
            throw new ConfigurationException("Failed to determine the number of CPUs available to this process from " + file.getAbsolutePath() + " contents:\n" + string);
        }
        return n2;
    }

    private static String safeRead(File file) throws ConfigurationException {
        String string;
        block12: {
            Objects.requireNonNull(file);
            if (!FileUtil.isAccessible(file)) {
                throw new ConfigurationException(file.getAbsolutePath() + " is not readable.");
            }
            InputStream inputStream = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
            try {
                byte[] byArray = new byte[64];
                int n2 = inputStream.read(byArray);
                if (n2 <= 0) {
                    throw new ConfigurationException("Failed to read: " + file.getAbsolutePath());
                }
                if (n2 >= byArray.length) {
                    throw new ConfigurationException("Failed to read: " + file.getAbsolutePath());
                }
                String string2 = StringUtils.trimToNull(new String(byArray, 0, n2, StandardCharsets.UTF_8));
                if (string2 == null) {
                    throw new ConfigurationException("Failed to read: " + file.getAbsolutePath());
                }
                string = string2;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable4 = throwable3;
                            throwable2.addSuppressed(throwable4);
                        }
                    }
                    throw throwable2;
                }
                catch (IOException iOException) {
                    throw new ConfigurationException("Failed to read: " + file.getAbsolutePath(), iOException);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public void onLoggerInitialized() {
        Throwable throwable = this.configurationException.getAndSet(null);
        if (throwable == null) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(CpuInfo.class);
        if (Double.isNaN(this.effectiveCpus)) {
            logger.debug("Failed to detect effective CPUs available to this process.", throwable);
        }
    }

    @DontObfuscate
    public static final class ConfigurationException
    extends Exception {
        private ConfigurationException(String string) {
            super(string);
        }

        private ConfigurationException(String string, Throwable throwable) {
            super(string, throwable);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class a {
        private final String a;
        private int b;

        private a(String string) {
            this.a = string;
        }

        boolean a() {
            return this.b >= this.a.length();
        }

        boolean a(char c2) {
            if (this.a() || c2 != this.a.charAt(this.b)) {
                return false;
            }
            ++this.b;
            return true;
        }

        boolean a(F.a a2) {
            int n2 = this.b;
            while (!this.a() && a2.d.test(this.a.charAt(this.b))) {
                ++this.b;
            }
            return n2 < this.b;
        }

        long b() {
            int n2 = this.b;
            if (!this.a(F.a.b)) {
                return -1L;
            }
            try {
                long l2 = Long.parseLong(this.a.substring(n2, this.b));
                return 0L <= l2 && l2 < 0x100000000L ? l2 : -1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }
    }
}

