/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Inflater;
import java.util.zip.ZipFile;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@DontObfuscate
public final class JVMUtils {
    private static final Supplier<Boolean> SUPPORTS_MODULES = Suppliers.memoize(() -> {
        try {
            return Class.forName("java.lang.Module") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    });
    private static final String JAVA_HOME = n.b("java.home");
    private static final String JAVA_HOME_PATH = JAVA_HOME + File.separatorChar + "bin" + File.separatorChar + "java";
    private static final String JAVA_VERSION = n.b("java.version");
    private static final String JAVA_RUNTIME_NAME = n.b("java.runtime.name");
    private static final String JAVA_RUNTIME_VERSION = n.b("java.runtime.version");
    private static final String JAVA_SPEC_VERSION = n.b("java.specification.version");
    private static final String JAVA_VENDOR = n.b("java.vendor");
    private static final String JAVA_VM_NAME = n.b("java.vm.name");
    private static final String GRAILS_HOME = n.b("grails.home");
    private static final boolean IS_IBM_JVM = JAVA_VENDOR != null && JAVA_VENDOR.contains("IBM") || JAVA_VM_NAME != null && JAVA_VM_NAME.contains("J9");
    private static final boolean IS_JROCKIT = JAVA_VM_NAME != null && JAVA_VM_NAME.toLowerCase().contains("jrockit");
    private static final boolean IS_OPENJDK_BASED = JAVA_VM_NAME != null && (JAVA_VM_NAME.toLowerCase().contains("openjdk") || JAVA_VM_NAME.toLowerCase().contains("hotspot"));
    private static final boolean IS_JAVA6_7 = JAVA_VERSION.startsWith("1.6.") || JAVA_VERSION.startsWith("1.7.");
    private static final boolean IS_JAVA_6 = JAVA_VERSION.startsWith("1.6.");
    private static final boolean IS_JAVA_8 = JAVA_VERSION.startsWith("1.8.");
    private static final Float JAVA_SPEC_VERSION_FLOAT = JVMUtils.parseFloatString(JAVA_SPEC_VERSION);
    private static final boolean JAVA_VERSION_13_OR_HIGHER = !JAVA_SPEC_VERSION_FLOAT.isNaN() && JAVA_SPEC_VERSION_FLOAT.floatValue() >= 13.0f;
    private static final boolean JAVA_VERSION_21_OR_HIGHER = !JAVA_SPEC_VERSION_FLOAT.isNaN() && JAVA_SPEC_VERSION_FLOAT.floatValue() >= 21.0f;
    private static final boolean IS_IBM_JVM_8 = IS_IBM_JVM && IS_JAVA_8;
    private static final String JAVA_PREFIX = "java.";
    private static final Map<String, Class<?>> COMMON_TYPE_MAP = Maps.builder().add("java.io.InputStream", InputStream.class).add("java.io.ByteArrayInputStream", ByteArrayInputStream.class).add("java.io.ObjectInputStream", ObjectInputStream.class).add("java.io.PrintWriter", PrintWriter.class).add("java.io.File", File.class).add("java.io.FileDescriptor", FileDescriptor.class).add("java.io.Reader", Reader.class).add("java.lang.CharSequence", CharSequence.class).add("java.lang.Class", Class.class).add("java.lang.ClassLoader", ClassLoader.class).add("java.lang.String", String.class).add("java.nio.ByteBuffer", ByteBuffer.class).add("java.nio.charset.Charset", Charset.class).add("java.util.zip.ZipFile", ZipFile.class).add("java.util.zip.Inflater", Inflater.class).add("int", Integer.TYPE).add("long", Long.TYPE).add("boolean", Boolean.TYPE).add("byte[]", byte[].class).build();

    private JVMUtils() {
    }

    public static Class<?> findClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = COMMON_TYPE_MAP.get(string);
        return clazz == null ? n.a(string, false, classLoader) : clazz;
    }

    public static String[] getClassPath() {
        String string = StringUtils.trimToNull(n.b("java.class.path"));
        return string == null ? Empty.STRING_ARRAY : StringUtils.split(string, File.pathSeparatorChar);
    }

    public static boolean doesSupportModules() {
        return SUPPORTS_MODULES.get();
    }

    public static String getModuleName(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        if (!JVMUtils.doesSupportModules()) {
            return null;
        }
        return JVMUtils.getModuleNameUnsafe(clazz);
    }

    @IgnoreJRERequirement
    private static String getModuleNameUnsafe(Class<?> clazz) {
        return clazz.getModule().getName();
    }

    public static boolean isIBMJVM() {
        return IS_IBM_JVM;
    }

    public static boolean isIBMJVM8() {
        return IS_IBM_JVM_8;
    }

    public static boolean isGrails() {
        return GRAILS_HOME != null;
    }

    public static boolean isJRockitJVM() {
        return IS_JROCKIT;
    }

    public static boolean isJava6Through7() {
        return IS_JAVA6_7;
    }

    public static boolean isJava6() {
        return IS_JAVA_6;
    }

    public static boolean isJava8() {
        return IS_JAVA_8;
    }

    public static boolean isAtLeastJavaVersion13() {
        return JAVA_VERSION_13_OR_HIGHER;
    }

    public static boolean isAtLeastJavaVersion21() {
        return JAVA_VERSION_21_OR_HIGHER;
    }

    public static boolean isOpenJdkBased() {
        return IS_OPENJDK_BASED;
    }

    public static int getHashCode(Object object) {
        int n2 = object instanceof String ? object.hashCode() : System.identityHashCode(object);
        return n2;
    }

    public static String getSafeToString(Object object) {
        return JVMUtils.getSafeToString(object, false);
    }

    public static String getSafeToString(Object object, boolean bl2) {
        if (object == null) {
            return "null";
        }
        if (!bl2) {
            return object.getClass().getName() + '@' + StringUtils.leftPad(Integer.toHexString(System.identityHashCode(object)), 8, '0');
        }
        Class<?> clazz = object.getClass();
        return JVMUtils.getSafeToStringSimple(JVMUtils.getSimpleClass(clazz), System.identityHashCode(object), clazz.isArray());
    }

    public static String getSimpleClass(Class<?> clazz) {
        String string;
        boolean bl2 = clazz.isArray();
        try {
            string = bl2 ? clazz.getComponentType().getSimpleName() : clazz.getSimpleName();
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            string = clazz.getName();
        }
        if (string.isEmpty()) {
            string = clazz.getName();
        }
        return string;
    }

    public static String getSafeToStringSimple(String string, int n2, boolean bl2) {
        int n3 = 16;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append("[]");
        }
        return stringBuilder.append('@').append(StringUtils.leftPad(Integer.toHexString(n2), 8, '0')).toString();
    }

    public static boolean isJvmClassLoader(ClassLoader classLoader) {
        return classLoader == null || classLoader == ClassLoader.getSystemClassLoader();
    }

    public static boolean isInstanceOf(Object object, String string) {
        if (object != null && string != null) {
            Object object2;
            Class<?> clazz = object.getClass();
            if (clazz != null && ((String)(object2 = clazz.getName())).equals(string)) {
                return true;
            }
            object2 = n.a(Thread.currentThread());
            boolean bl2 = JVMUtils.isJvmClassLoader((ClassLoader)object2);
            if (!bl2) {
                boolean bl3 = string.startsWith(JAVA_PREFIX);
                if (bl3) {
                    object2 = ClassLoader.getSystemClassLoader();
                } else {
                    return false;
                }
            }
            try {
                Class<?> clazz2 = JVMUtils.findClass(string, (ClassLoader)object2);
                if (clazz2.isAssignableFrom(object.getClass())) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
            }
        }
        return false;
    }

    public static boolean isSystemJar(String string) {
        if (!StringUtils.isEmpty(JAVA_HOME)) {
            return string.contains(JAVA_HOME);
        }
        return false;
    }

    public static String getJavaHome() {
        return JAVA_HOME;
    }

    public static String getJavaHomePath() {
        return JAVA_HOME_PATH;
    }

    public static String getJavaRuntimeName() {
        return JAVA_RUNTIME_NAME;
    }

    public static String getJavaRuntimeVersion() {
        return JAVA_RUNTIME_VERSION;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    private static Float parseFloatString(String string) {
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Float.valueOf(Float.NaN);
        }
    }
}

