/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cesyb.emitter;

import java.util.regex.Pattern;

class ScalarAnalysis {
    private static final Pattern DOCUMENT_INDICATOR = Pattern.compile("^(---|\\.\\.\\.)");
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n\u0085";
    private static final String SPECIAL_INDICATOR = "#,[]{}#&*!|>'\"%@`";
    private static final String FLOW_INDICATOR = ",?[]{}";
    public final String scalar;
    public final boolean empty;
    public final boolean multiline;
    public final boolean allowFlowPlain;
    public final boolean allowBlockPlain;
    public final boolean allowSingleQuoted;
    public final boolean allowDoubleQuoted;
    public final boolean allowBlock;

    private ScalarAnalysis(String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.scalar = string;
        this.empty = bl2;
        this.multiline = bl3;
        this.allowFlowPlain = bl4;
        this.allowBlockPlain = bl5;
        this.allowSingleQuoted = bl6;
        this.allowDoubleQuoted = bl7;
        this.allowBlock = bl8;
    }

    public static ScalarAnalysis analyze(String string, boolean bl2) {
        boolean bl3;
        if (string == null) {
            return new ScalarAnalysis(string, true, false, false, true, true, true, false);
        }
        if ("".equals(string)) {
            return new ScalarAnalysis(string, false, false, false, false, false, true, false);
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        if (DOCUMENT_INDICATOR.matcher(string).matches()) {
            bl4 = true;
            bl5 = true;
        }
        boolean bl15 = true;
        boolean bl16 = string.length() == 1 || NULL_BL_T_LINEBR.indexOf(string.charAt(1)) != -1;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char bl32 = string.charAt(n2);
            if (n2 == 0) {
                if (SPECIAL_INDICATOR.indexOf(bl32) != -1) {
                    bl5 = true;
                    bl4 = true;
                }
                if (bl32 == '?' || bl32 == ':') {
                    bl5 = true;
                    if (bl16) {
                        bl4 = true;
                    }
                }
                if (bl32 == '-' && bl16) {
                    bl5 = true;
                    bl4 = true;
                }
            } else {
                if (FLOW_INDICATOR.indexOf(bl32) != -1) {
                    bl5 = true;
                }
                if (bl32 == ':') {
                    bl5 = true;
                    if (bl16) {
                        bl4 = true;
                    }
                }
                if (bl32 == '#' && bl15) {
                    bl5 = true;
                    bl4 = true;
                }
            }
            if (bl32 == '\n' || '\u0085' == bl32) {
                bl6 = true;
            }
            if (bl2 && bl32 != '\n' && bl32 != '\t' && (' ' > bl32 || bl32 > '~')) {
                bl7 = true;
            }
            if (' ' == bl32 || '\n' == bl32 || '\u0085' == bl32) {
                if (bl17 && bl18) {
                    if (bl32 != ' ') {
                        bl19 = true;
                    }
                } else if (bl17) {
                    if (bl32 != ' ') {
                        bl18 = true;
                        bl19 = true;
                    }
                } else if (bl18) {
                    if (bl32 == ' ') {
                        bl17 = true;
                    }
                } else {
                    boolean bl21 = bl20 = n2 == 0;
                    if (bl32 == ' ') {
                        bl17 = true;
                    } else {
                        bl18 = true;
                    }
                }
            } else if (bl17 || bl18) {
                if (bl20) {
                    if (bl17 && bl18) {
                        bl14 = true;
                    } else if (bl17) {
                        bl9 = true;
                    } else if (bl18) {
                        bl10 = true;
                    }
                } else if (bl19) {
                    bl14 = true;
                } else if (bl17 && bl18) {
                    bl13 = true;
                } else if (!bl17 && bl18) {
                    bl8 = true;
                }
                bl20 = false;
                bl19 = false;
                bl18 = false;
                bl17 = false;
            }
            if ((bl17 || bl18) && n2 == string.length() - 1) {
                if (bl17 && bl18) {
                    bl14 = true;
                } else if (bl17) {
                    bl11 = true;
                    if (bl20) {
                        bl9 = true;
                    }
                } else if (bl18) {
                    bl12 = true;
                    if (bl20) {
                        bl10 = true;
                    }
                }
                bl20 = false;
                bl19 = false;
                bl18 = false;
                bl17 = false;
            }
            bl15 = NULL_BL_T_LINEBR.indexOf(bl32) != -1;
            bl16 = ++n2 + 1 >= string.length() || NULL_BL_T_LINEBR.indexOf(string.charAt(n2 + 1)) != -1;
        }
        boolean bl22 = true;
        boolean bl23 = true;
        boolean bl24 = true;
        boolean bl25 = true;
        boolean bl26 = true;
        if (bl9 || bl10 || bl11) {
            bl26 = false;
            bl23 = false;
            boolean bl27 = false;
        }
        if (bl12) {
            bl23 = false;
            boolean bl28 = false;
        }
        if (bl13) {
            bl24 = false;
            bl23 = false;
            boolean bl29 = false;
        }
        if (bl14 || bl7) {
            bl26 = false;
            bl24 = false;
            bl23 = false;
            boolean bl30 = false;
        }
        if (bl8) {
            bl24 = false;
            bl23 = false;
            boolean bl31 = false;
        }
        if (bl12) {
            bl24 = false;
        }
        if (bl6) {
            bl23 = false;
            boolean bl32 = false;
        }
        if (bl5) {
            bl3 = false;
        }
        if (bl4) {
            bl23 = false;
        }
        return new ScalarAnalysis(string, false, bl6, bl3, bl23, bl24, bl25, bl26);
    }
}

