/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import com.contrastsecurity.thirdparty.crmq.client.AMQP;
import com.contrastsecurity.thirdparty.crmq.client.Channel;
import com.contrastsecurity.thirdparty.crmq.client.Consumer;
import com.contrastsecurity.thirdparty.crmq.client.DefaultConsumer;
import com.contrastsecurity.thirdparty.crmq.client.Envelope;
import com.contrastsecurity.thirdparty.crmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.crmq.client.impl.MethodArgumentReader;
import com.contrastsecurity.thirdparty.crmq.client.impl.MethodArgumentWriter;
import com.contrastsecurity.thirdparty.crmq.client.impl.ValueReader;
import com.contrastsecurity.thirdparty.crmq.client.impl.ValueWriter;
import com.contrastsecurity.thirdparty.crmq.utility.BlockingCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class RpcClient {
    private final Channel _channel;
    private final String _exchange;
    private final String _routingKey;
    private final String _replyTo;
    private final int _timeout;
    protected static final int NO_TIMEOUT = -1;
    private final Map<String, BlockingCell<Object>> _continuationMap = new HashMap<String, BlockingCell<Object>>();
    private int _correlationId;
    private DefaultConsumer _consumer;

    public RpcClient(Channel channel, String string, String string2, String string3, int n2) throws IOException {
        this._channel = channel;
        this._exchange = string;
        this._routingKey = string2;
        this._replyTo = string3;
        if (n2 < -1) {
            throw new IllegalArgumentException("Timeout arguument must be NO_TIMEOUT(-1) or non-negative.");
        }
        this._timeout = n2;
        this._correlationId = 0;
        this._consumer = this.setupConsumer();
    }

    public RpcClient(Channel channel, String string, String string2, String string3) throws IOException {
        this(channel, string, string2, string3, -1);
    }

    public RpcClient(Channel channel, String string, String string2) throws IOException {
        this(channel, string, string2, "amq.rabbitmq.reply-to", -1);
    }

    public RpcClient(Channel channel, String string, String string2, int n2) throws IOException {
        this(channel, string, string2, "amq.rabbitmq.reply-to", n2);
    }

    public void checkConsumer() throws IOException {
        if (this._consumer == null) {
            throw new EOFException("RpcClient is closed");
        }
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
    }

    protected DefaultConsumer setupConsumer() throws IOException {
        DefaultConsumer defaultConsumer = new DefaultConsumer(this._channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleShutdownSignal(String string, ShutdownSignalException shutdownSignalException) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    for (Map.Entry entry : RpcClient.this._continuationMap.entrySet()) {
                        ((BlockingCell)entry.getValue()).set(shutdownSignalException);
                    }
                    RpcClient.this._consumer = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleDelivery(String string, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    String string2 = basicProperties.getCorrelationId();
                    BlockingCell blockingCell = (BlockingCell)RpcClient.this._continuationMap.remove(string2);
                    if (blockingCell == null) {
                        throw new IllegalStateException("No outstanding request for correlation ID " + string2);
                    }
                    blockingCell.set(new Response(string, envelope, basicProperties, byArray));
                }
            }
        };
        this._channel.basicConsume(this._replyTo, true, defaultConsumer);
        return defaultConsumer;
    }

    public void publish(AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this._channel.basicPublish(this._exchange, this._routingKey, basicProperties, byArray);
    }

    public Response doCall(AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException, TimeoutException {
        return this.doCall(basicProperties, byArray, this._timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doCall(AMQP.BasicProperties basicProperties, byte[] byArray, int n2) throws IOException, ShutdownSignalException, TimeoutException {
        Object object;
        this.checkConsumer();
        BlockingCell blockingCell = new BlockingCell();
        Map<String, BlockingCell<Object>> map = this._continuationMap;
        synchronized (map) {
            ++this._correlationId;
            object = "" + this._correlationId;
            basicProperties = (basicProperties == null ? new AMQP.BasicProperties.Builder() : basicProperties.builder()).correlationId((String)object).replyTo(this._replyTo).build();
            this._continuationMap.put((String)object, blockingCell);
        }
        this.publish(basicProperties, byArray);
        map = blockingCell.uninterruptibleGet(n2);
        if (map instanceof ShutdownSignalException) {
            object = (ShutdownSignalException)((Object)map);
            ShutdownSignalException shutdownSignalException = new ShutdownSignalException(((ShutdownSignalException)object).isHardError(), ((ShutdownSignalException)object).isInitiatedByApplication(), ((ShutdownSignalException)object).getReason(), ((ShutdownSignalException)object).getReference());
            shutdownSignalException.initCause((Throwable)object);
            throw shutdownSignalException;
        }
        return (Response)((Object)map);
    }

    public byte[] primitiveCall(AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(basicProperties, byArray, this._timeout);
    }

    public byte[] primitiveCall(AMQP.BasicProperties basicProperties, byte[] byArray, int n2) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(basicProperties, byArray, n2).getBody();
    }

    public byte[] primitiveCall(byte[] byArray) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(null, byArray);
    }

    public Response responseCall(byte[] byArray) throws IOException, ShutdownSignalException, TimeoutException {
        return this.responseCall(byArray, this._timeout);
    }

    public Response responseCall(byte[] byArray, int n2) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(null, byArray, n2);
    }

    public String stringCall(String string) throws IOException, ShutdownSignalException, TimeoutException {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (IOException iOException) {
            byArray = string.getBytes();
        }
        byte[] byArray2 = this.primitiveCall(byArray);
        try {
            return new String(byArray2, "UTF-8");
        }
        catch (IOException iOException) {
            return new String(byArray2);
        }
    }

    public Map<String, Object> mapCall(Map<String, Object> map) throws IOException, ShutdownSignalException, TimeoutException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MethodArgumentWriter methodArgumentWriter = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(byteArrayOutputStream)));
        methodArgumentWriter.writeTable(map);
        methodArgumentWriter.flush();
        byte[] byArray = this.primitiveCall(byteArrayOutputStream.toByteArray());
        MethodArgumentReader methodArgumentReader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(byArray))));
        return methodArgumentReader.readTable();
    }

    public Map<String, Object> mapCall(Object[] objectArray) throws IOException, ShutdownSignalException, TimeoutException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            hashMap.put((String)objectArray[i2], objectArray[i2 + 1]);
        }
        return this.mapCall(hashMap);
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public Map<String, BlockingCell<Object>> getContinuationMap() {
        return this._continuationMap;
    }

    public int getCorrelationId() {
        return this._correlationId;
    }

    public Consumer getConsumer() {
        return this._consumer;
    }

    public static class Response {
        protected String consumerTag;
        protected Envelope envelope;
        protected AMQP.BasicProperties properties;
        protected byte[] body;

        public Response() {
        }

        public Response(String string, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) {
            this.consumerTag = string;
            this.envelope = envelope;
            this.properties = basicProperties;
            this.body = byArray;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this.properties;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

