/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.Channel;
import com.contrastsecurity.thirdparty.crmq.client.Connection;
import com.contrastsecurity.thirdparty.crmq.client.impl.AbstractMetricsCollector;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class MicrometerMetricsCollector
extends AbstractMetricsCollector {
    private final AtomicLong connections;
    private final AtomicLong channels;
    private final Counter publishedMessages;
    private final Counter consumedMessages;
    private final Counter acknowledgedMessages;
    private final Counter rejectedMessages;

    public MicrometerMetricsCollector(MeterRegistry meterRegistry) {
        this(meterRegistry, "rabbitmq");
    }

    public MicrometerMetricsCollector(MeterRegistry meterRegistry, String string) {
        this(meterRegistry, string, new String[0]);
    }

    public MicrometerMetricsCollector(MeterRegistry meterRegistry, String string, String ... stringArray) {
        this(meterRegistry, string, Tags.of(stringArray));
    }

    public MicrometerMetricsCollector(final MeterRegistry meterRegistry, final String string, final Iterable<Tag> iterable) {
        this(new MetricsCreator(){

            @Override
            public Object create(Metrics metrics) {
                return metrics.create(meterRegistry, string, iterable);
            }
        });
    }

    public MicrometerMetricsCollector(MetricsCreator metricsCreator) {
        this.connections = (AtomicLong)metricsCreator.create(Metrics.CONNECTIONS);
        this.channels = (AtomicLong)metricsCreator.create(Metrics.CHANNELS);
        this.publishedMessages = (Counter)metricsCreator.create(Metrics.PUBLISHED_MESSAGES);
        this.consumedMessages = (Counter)metricsCreator.create(Metrics.CONSUMED_MESSAGES);
        this.acknowledgedMessages = (Counter)metricsCreator.create(Metrics.ACKNOWLEDGED_MESSAGES);
        this.rejectedMessages = (Counter)metricsCreator.create(Metrics.REJECTED_MESSAGES);
    }

    @Override
    protected void incrementConnectionCount(Connection connection) {
        this.connections.incrementAndGet();
    }

    @Override
    protected void decrementConnectionCount(Connection connection) {
        this.connections.decrementAndGet();
    }

    @Override
    protected void incrementChannelCount(Channel channel) {
        this.channels.incrementAndGet();
    }

    @Override
    protected void decrementChannelCount(Channel channel) {
        this.channels.decrementAndGet();
    }

    @Override
    protected void markPublishedMessage() {
        this.publishedMessages.increment();
    }

    @Override
    protected void markConsumedMessage() {
        this.consumedMessages.increment();
    }

    @Override
    protected void markAcknowledgedMessage() {
        this.acknowledgedMessages.increment();
    }

    @Override
    protected void markRejectedMessage() {
        this.rejectedMessages.increment();
    }

    public AtomicLong getConnections() {
        return this.connections;
    }

    public AtomicLong getChannels() {
        return this.channels;
    }

    public Counter getPublishedMessages() {
        return this.publishedMessages;
    }

    public Counter getConsumedMessages() {
        return this.consumedMessages;
    }

    public Counter getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public Counter getRejectedMessages() {
        return this.rejectedMessages;
    }

    public static interface MetricsCreator {
        public Object create(Metrics var1);
    }

    public static enum Metrics {
        CONNECTIONS{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.gauge(string + ".connections", iterable, new AtomicLong(0L));
            }
        }
        ,
        CHANNELS{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.gauge(string + ".channels", iterable, new AtomicLong(0L));
            }
        }
        ,
        PUBLISHED_MESSAGES{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.counter(string + ".published", iterable);
            }
        }
        ,
        CONSUMED_MESSAGES{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.counter(string + ".consumed", iterable);
            }
        }
        ,
        ACKNOWLEDGED_MESSAGES{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.counter(string + ".acknowledged", iterable);
            }
        }
        ,
        REJECTED_MESSAGES{

            @Override
            Object create(MeterRegistry meterRegistry, String string, Iterable<Tag> iterable) {
                return meterRegistry.counter(string + ".rejected", iterable);
            }
        };


        @Deprecated
        Object create(MeterRegistry meterRegistry, String string) {
            return this.create(meterRegistry, string, Collections.<Tag>emptyList());
        }

        abstract Object create(MeterRegistry var1, String var2, Iterable<Tag> var3);
    }
}

