/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.nio;

import com.contrastsecurity.thirdparty.crmq.client.SocketChannelConfigurator;
import com.contrastsecurity.thirdparty.crmq.client.SocketChannelConfigurators;
import com.contrastsecurity.thirdparty.crmq.client.SslEngineConfigurator;
import com.contrastsecurity.thirdparty.crmq.client.SslEngineConfigurators;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.BlockingQueueNioQueue;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.ByteBufferFactory;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.DefaultByteBufferFactory;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioContext;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioQueue;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioQueueFactory;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.WriteRequest;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLEngine;

public class NioParams {
    static NioQueueFactory DEFAULT_WRITE_QUEUE_FACTORY = new NioQueueFactory(){

        @Override
        public NioQueue create(NioContext nioContext) {
            return new BlockingQueueNioQueue(new ArrayBlockingQueue<WriteRequest>(nioContext.getNioParams().getWriteQueueCapacity(), true), nioContext.getNioParams().getWriteEnqueuingTimeoutInMs());
        }
    };
    private int readByteBufferSize = 32768;
    private int writeByteBufferSize = 32768;
    private int nbIoThreads = 1;
    private int writeEnqueuingTimeoutInMs = 10000;
    private int writeQueueCapacity = 10000;
    private ExecutorService nioExecutor;
    private ThreadFactory threadFactory;
    private SocketChannelConfigurator socketChannelConfigurator = SocketChannelConfigurators.defaultConfigurator();
    private SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(){

        @Override
        public void configure(SSLEngine sSLEngine) throws IOException {
        }
    };
    private ExecutorService connectionShutdownExecutor;
    private ByteBufferFactory byteBufferFactory = new DefaultByteBufferFactory();
    private NioQueueFactory writeQueueFactory = DEFAULT_WRITE_QUEUE_FACTORY;

    public NioParams() {
    }

    public NioParams(NioParams nioParams) {
        this.setReadByteBufferSize(nioParams.getReadByteBufferSize());
        this.setWriteByteBufferSize(nioParams.getWriteByteBufferSize());
        this.setNbIoThreads(nioParams.getNbIoThreads());
        this.setWriteEnqueuingTimeoutInMs(nioParams.getWriteEnqueuingTimeoutInMs());
        this.setWriteQueueCapacity(nioParams.getWriteQueueCapacity());
        this.setNioExecutor(nioParams.getNioExecutor());
        this.setThreadFactory(nioParams.getThreadFactory());
        this.setSocketChannelConfigurator(nioParams.getSocketChannelConfigurator());
        this.setSslEngineConfigurator(nioParams.getSslEngineConfigurator());
        this.setConnectionShutdownExecutor(nioParams.getConnectionShutdownExecutor());
        this.setByteBufferFactory(nioParams.getByteBufferFactory());
        this.setWriteQueueFactory(nioParams.getWriteQueueFactory());
    }

    public NioParams enableHostnameVerification() {
        this.sslEngineConfigurator = this.sslEngineConfigurator == null ? SslEngineConfigurators.ENABLE_HOSTNAME_VERIFICATION : SslEngineConfigurators.builder().add(this.sslEngineConfigurator).enableHostnameVerification().build();
        return this;
    }

    public int getReadByteBufferSize() {
        return this.readByteBufferSize;
    }

    public NioParams setReadByteBufferSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        this.readByteBufferSize = n2;
        return this;
    }

    public int getWriteByteBufferSize() {
        return this.writeByteBufferSize;
    }

    public NioParams setWriteByteBufferSize(int n2) {
        if (this.readByteBufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        this.writeByteBufferSize = n2;
        return this;
    }

    public int getNbIoThreads() {
        return this.nbIoThreads;
    }

    public NioParams setNbIoThreads(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of threads must be greater than 0");
        }
        this.nbIoThreads = n2;
        return this;
    }

    public int getWriteEnqueuingTimeoutInMs() {
        return this.writeEnqueuingTimeoutInMs;
    }

    public NioParams setWriteEnqueuingTimeoutInMs(int n2) {
        this.writeEnqueuingTimeoutInMs = n2;
        return this;
    }

    public ExecutorService getNioExecutor() {
        return this.nioExecutor;
    }

    public NioParams setNioExecutor(ExecutorService executorService) {
        this.nioExecutor = executorService;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public NioParams setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public int getWriteQueueCapacity() {
        return this.writeQueueCapacity;
    }

    public NioParams setWriteQueueCapacity(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Write queue capacity must be greater than 0");
        }
        this.writeQueueCapacity = n2;
        return this;
    }

    public SocketChannelConfigurator getSocketChannelConfigurator() {
        return this.socketChannelConfigurator;
    }

    public void setSocketChannelConfigurator(SocketChannelConfigurator socketChannelConfigurator) {
        this.socketChannelConfigurator = socketChannelConfigurator;
    }

    public SslEngineConfigurator getSslEngineConfigurator() {
        return this.sslEngineConfigurator;
    }

    public void setSslEngineConfigurator(SslEngineConfigurator sslEngineConfigurator) {
        this.sslEngineConfigurator = sslEngineConfigurator;
    }

    public ExecutorService getConnectionShutdownExecutor() {
        return this.connectionShutdownExecutor;
    }

    public NioParams setConnectionShutdownExecutor(ExecutorService executorService) {
        this.connectionShutdownExecutor = executorService;
        return this;
    }

    public NioParams setByteBufferFactory(ByteBufferFactory byteBufferFactory) {
        this.byteBufferFactory = byteBufferFactory;
        return this;
    }

    public ByteBufferFactory getByteBufferFactory() {
        return this.byteBufferFactory;
    }

    public NioParams setWriteQueueFactory(NioQueueFactory nioQueueFactory) {
        this.writeQueueFactory = nioQueueFactory;
        return this;
    }

    public NioQueueFactory getWriteQueueFactory() {
        return this.writeQueueFactory;
    }
}

