/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.tools.jsonrpc;

import com.contrastsecurity.thirdparty.crmq.client.Channel;
import com.contrastsecurity.thirdparty.crmq.client.RpcClient;
import com.contrastsecurity.thirdparty.crmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.crmq.tools.json.JSONReader;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.DefaultJsonRpcMapper;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcException;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcMapper;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ParameterDescription;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ProcedureDescription;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ServiceDescription;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class JsonRpcClient
extends RpcClient
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRpcClient.class);
    private final JsonRpcMapper mapper;
    private ServiceDescription serviceDescription;

    public JsonRpcClient(Channel channel, String string, String string2, int n2, JsonRpcMapper jsonRpcMapper) throws IOException, JsonRpcException, TimeoutException {
        super(channel, string, string2, n2);
        this.mapper = jsonRpcMapper;
        this.retrieveServiceDescription();
    }

    public JsonRpcClient(Channel channel, String string, String string2, int n2) throws IOException, JsonRpcException, TimeoutException {
        this(channel, string, string2, n2, new DefaultJsonRpcMapper());
    }

    public JsonRpcClient(Channel channel, String string, String string2) throws IOException, JsonRpcException, TimeoutException {
        this(channel, string, string2, -1);
    }

    @Deprecated
    public static Object coerce(String string, String string2) throws NumberFormatException {
        if ("bit".equals(string2)) {
            return Boolean.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("num".equals(string2)) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.valueOf(string);
            }
        }
        if ("str".equals(string2)) {
            return string;
        }
        if ("arr".equals(string2) || "obj".equals(string2) || "any".equals(string2)) {
            return new JSONReader().read(string);
        }
        if ("nil".equals(string2)) {
            return null;
        }
        throw new IllegalArgumentException("Bad type: " + string2);
    }

    private Object checkReply(JsonRpcMapper.JsonRpcResponse jsonRpcResponse) throws JsonRpcException {
        if (jsonRpcResponse.getError() != null) {
            throw jsonRpcResponse.getException();
        }
        return jsonRpcResponse.getResult();
    }

    public Object call(String string, Object[] objectArray) throws IOException, JsonRpcException, TimeoutException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", null);
        hashMap.put("method", string);
        hashMap.put("version", "1.1");
        objectArray = objectArray == null ? new Object[]{} : objectArray;
        hashMap.put("params", objectArray);
        String string2 = this.mapper.write(hashMap);
        try {
            Object object;
            Class clazz;
            String string3 = this.stringCall(string2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reply string: {}", (Object)string3);
            }
            if ("system.describe".equals(string) && objectArray.length == 0) {
                clazz = Map.class;
            } else {
                object = this.serviceDescription.getProcedure(string, objectArray.length);
                clazz = ((ProcedureDescription)object).getReturnType();
            }
            object = this.mapper.parse(string3, clazz);
            return this.checkReply((JsonRpcMapper.JsonRpcResponse)object);
        }
        catch (ShutdownSignalException shutdownSignalException) {
            throw new IOException(shutdownSignalException.getMessage());
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.call(method.getName(), objectArray);
    }

    public <T> T createProxy(Class<T> clazz) throws IllegalArgumentException {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
    }

    @Deprecated
    public Object call(String[] stringArray) throws NumberFormatException, IOException, JsonRpcException, TimeoutException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("First string argument must be method name");
        }
        String string = stringArray[0];
        int n2 = stringArray.length - 1;
        ProcedureDescription procedureDescription = this.serviceDescription.getProcedure(string, n2);
        ParameterDescription[] parameterDescriptionArray = procedureDescription.getParams();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < parameterDescriptionArray.length; ++i2) {
            objectArray[i2] = JsonRpcClient.coerce(stringArray[i2 + 1], parameterDescriptionArray[i2].type);
        }
        return this.call(string, objectArray);
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    private void retrieveServiceDescription() throws IOException, JsonRpcException, TimeoutException {
        Map map = (Map)this.call("system.describe", null);
        this.serviceDescription = new ServiceDescription(map);
    }
}

