/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.db4j.automaton;

import com.contrastsecurity.thirdparty.db4j.automaton.Transition;
import com.contrastsecurity.thirdparty.db4j.automaton.TransitionComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class State
implements Serializable,
Comparable<State> {
    static final long serialVersionUID = 30001L;
    boolean accept;
    Set<Transition> transitions;
    int number;
    int id;
    static int next_id;

    public State() {
        this.resetTransitions();
        this.id = next_id++;
    }

    final void resetTransitions() {
        this.transitions = new HashSet<Transition>();
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public void setAccept(boolean bl2) {
        this.accept = bl2;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public State step(char c2) {
        for (Transition transition : this.transitions) {
            if (transition.min > c2 || c2 > transition.max) continue;
            return transition.to;
        }
        return null;
    }

    public void step(char c2, Collection<State> collection) {
        for (Transition transition : this.transitions) {
            if (transition.min > c2 || c2 > transition.max) continue;
            collection.add(transition.to);
        }
    }

    void addEpsilon(State state) {
        if (state.accept) {
            this.accept = true;
        }
        this.transitions.addAll(state.transitions);
    }

    Transition[] getSortedTransitionArray(boolean bl2) {
        Transition[] transitionArray = this.transitions.toArray(new Transition[this.transitions.size()]);
        Arrays.sort(transitionArray, new TransitionComparator(bl2));
        return transitionArray;
    }

    public List<Transition> getSortedTransitions(boolean bl2) {
        return Arrays.asList(this.getSortedTransitionArray(bl2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state ").append(this.number);
        if (this.accept) {
            stringBuilder.append(" [accept]");
        } else {
            stringBuilder.append(" [reject]");
        }
        stringBuilder.append(":\n");
        for (Transition transition : this.transitions) {
            stringBuilder.append("  ").append(transition.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(State state) {
        return state.id - this.id;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

