/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs.internal;

import com.contrastsecurity.thirdparty.dfs.internal.CircuitStats;
import java.util.BitSet;

class CountingCircuitStats
implements CircuitStats {
    final BitSet bitSet;
    private final int size;
    volatile int currentIndex;
    private volatile int occupiedBits;
    private volatile int successes;
    private volatile int failures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountingCircuitStats(int n2, CircuitStats circuitStats) {
        this.bitSet = new BitSet(n2);
        this.size = n2;
        if (circuitStats != null) {
            CircuitStats circuitStats2 = circuitStats;
            synchronized (circuitStats2) {
                this.copyStats(circuitStats);
            }
        }
    }

    void copyStats(CircuitStats circuitStats) {
        if (circuitStats instanceof CountingCircuitStats) {
            CountingCircuitStats countingCircuitStats = (CountingCircuitStats)circuitStats;
            int n2 = Math.min(countingCircuitStats.occupiedBits, this.size);
            int n3 = countingCircuitStats.currentIndex - n2;
            if (n3 < 0) {
                n3 += countingCircuitStats.occupiedBits;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.setNext(countingCircuitStats.bitSet.get(n3));
                n3 = countingCircuitStats.indexAfter(n3);
            }
        } else {
            this.copyExecutions(circuitStats);
        }
    }

    @Override
    public void recordSuccess() {
        this.setNext(true);
    }

    @Override
    public void recordFailure() {
        this.setNext(false);
    }

    @Override
    public int getExecutionCount() {
        return this.occupiedBits;
    }

    @Override
    public int getFailureCount() {
        return this.failures;
    }

    @Override
    public synchronized int getFailureRate() {
        return (int)Math.round(this.occupiedBits == 0 ? 0.0 : (double)this.failures / (double)this.occupiedBits * 100.0);
    }

    @Override
    public int getSuccessCount() {
        return this.successes;
    }

    @Override
    public synchronized int getSuccessRate() {
        return (int)Math.round(this.occupiedBits == 0 ? 0.0 : (double)this.successes / (double)this.occupiedBits * 100.0);
    }

    @Override
    public synchronized void reset() {
        this.bitSet.clear();
        this.currentIndex = 0;
        this.occupiedBits = 0;
        this.successes = 0;
        this.failures = 0;
    }

    synchronized int setNext(boolean bl2) {
        int n2 = -1;
        if (this.occupiedBits < this.size) {
            ++this.occupiedBits;
        } else {
            n2 = this.bitSet.get(this.currentIndex) ? 1 : 0;
        }
        this.bitSet.set(this.currentIndex, bl2);
        this.currentIndex = this.indexAfter(this.currentIndex);
        if (bl2) {
            if (n2 != 1) {
                ++this.successes;
            }
            if (n2 == 0) {
                --this.failures;
            }
        } else {
            if (n2 != 0) {
                ++this.failures;
            }
            if (n2 == 1) {
                --this.successes;
            }
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        for (int i2 = 0; i2 < this.occupiedBits; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.bitSet.get(i2));
        }
        return stringBuilder.append(']').toString();
    }

    private int indexAfter(int n2) {
        return n2 == this.size - 1 ? 0 : n2 + 1;
    }
}

