/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class JvmCompilationMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;

    public JvmCompilationMetrics() {
        this(Collections.emptyList());
    }

    public JvmCompilationMetrics(Iterable<Tag> iterable) {
        this.tags = iterable;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean != null && compilationMXBean.isCompilationTimeMonitoringSupported()) {
            FunctionCounter.builder("jvm.compilation.time", compilationMXBean, CompilationMXBean::getTotalCompilationTime).tags(Tags.concat(this.tags, "compiler", compilationMXBean.getName())).description("The approximate accumulated elapsed time spent in compilation").baseUnit("ms").register(meterRegistry);
        }
    }
}

