/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.logging.LogbackMetrics;
import com.contrastsecurity.thirdparty.os4j.Marker;

@NonNullApi
@NonNullFields
class MetricsTurboFilter
extends TurboFilter {
    private static final String METER_NAME = "logback.events";
    private static final String METER_DESCRIPTION = "Number of log events that were enabled by the effective log level";
    private final Counter errorCounter;
    private final Counter warnCounter;
    private final Counter infoCounter;
    private final Counter debugCounter;
    private final Counter traceCounter;

    MetricsTurboFilter(MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        this.errorCounter = Counter.builder(METER_NAME).tags(iterable).tags("level", "error").description(METER_DESCRIPTION).baseUnit("events").register(meterRegistry);
        this.warnCounter = Counter.builder(METER_NAME).tags(iterable).tags("level", "warn").description(METER_DESCRIPTION).baseUnit("events").register(meterRegistry);
        this.infoCounter = Counter.builder(METER_NAME).tags(iterable).tags("level", "info").description(METER_DESCRIPTION).baseUnit("events").register(meterRegistry);
        this.debugCounter = Counter.builder(METER_NAME).tags(iterable).tags("level", "debug").description(METER_DESCRIPTION).baseUnit("events").register(meterRegistry);
        this.traceCounter = Counter.builder(METER_NAME).tags(iterable).tags("level", "trace").description(METER_DESCRIPTION).baseUnit("events").register(meterRegistry);
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return FilterReply.NEUTRAL;
        }
        Boolean bl2 = LogbackMetrics.ignoreMetrics.get();
        if (bl2 != null && bl2.booleanValue()) {
            return FilterReply.NEUTRAL;
        }
        LogbackMetrics.ignoreMetrics(() -> this.recordMetrics(logger, level));
        return FilterReply.NEUTRAL;
    }

    private void recordMetrics(Logger logger, Level level) {
        if (level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            switch (level.toInt()) {
                case 40000: {
                    this.errorCounter.increment();
                    break;
                }
                case 30000: {
                    this.warnCounter.increment();
                    break;
                }
                case 20000: {
                    this.infoCounter.increment();
                    break;
                }
                case 10000: {
                    this.debugCounter.increment();
                    break;
                }
                case 5000: {
                    this.traceCounter.increment();
                }
            }
        }
    }
}

