/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.distribution;

import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public final class CountAtBucket {
    private final double bucket;
    private final double count;

    @Deprecated
    public CountAtBucket(long l2, double d2) {
        this((double)l2, d2);
    }

    public CountAtBucket(double d2, double d3) {
        this.bucket = d2;
        this.count = d3;
    }

    public double bucket() {
        return this.bucket;
    }

    public double bucket(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.bucket, timeUnit);
    }

    public double count() {
        return this.count;
    }

    boolean isPositiveInf() {
        return this.bucket == Double.POSITIVE_INFINITY || this.bucket == Double.MAX_VALUE || (long)this.bucket == Long.MAX_VALUE;
    }

    public String toString() {
        return "(" + this.count + " at " + this.bucket + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CountAtBucket countAtBucket = (CountAtBucket)object;
        return Double.compare(countAtBucket.bucket, this.bucket) == 0 && Double.compare(countAtBucket.count, this.count) == 0;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.bucket);
        int n2 = (int)(l2 ^ l2 >>> 32);
        long l3 = Double.doubleToLongBits(this.count);
        n2 = 31 * n2 + (int)(l3 ^ l3 >>> 32);
        return n2;
    }
}

