/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.common;

import com.contrastsecurity.thirdparty.iot.api.common.ArrayBackedAttributesBuilder;
import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public interface AttributesBuilder {
    public Attributes build();

    public <T> AttributesBuilder put(AttributeKey<Long> var1, int var2);

    public <T> AttributesBuilder put(AttributeKey<T> var1, T var2);

    default public AttributesBuilder put(String string, String string2) {
        return this.put(AttributeKey.stringKey(string), (T)string2);
    }

    default public AttributesBuilder put(String string, long l2) {
        return this.put((AttributeKey<T>)AttributeKey.longKey(string), (T)l2);
    }

    default public AttributesBuilder put(String string, double d2) {
        return this.put(AttributeKey.doubleKey(string), (T)d2);
    }

    default public AttributesBuilder put(String string, boolean bl2) {
        return this.put(AttributeKey.booleanKey(string), (T)bl2);
    }

    default public AttributesBuilder put(String string, String ... stringArray) {
        if (stringArray == null) {
            return this;
        }
        return this.put(AttributeKey.stringArrayKey(string), (T)Arrays.asList(stringArray));
    }

    default public <T> AttributesBuilder put(AttributeKey<List<T>> attributeKey, T ... TArray) {
        if (TArray == null) {
            return this;
        }
        return this.put((AttributeKey<T>)attributeKey, (T)Arrays.asList(TArray));
    }

    default public AttributesBuilder put(String string, long ... lArray) {
        if (lArray == null) {
            return this;
        }
        return this.put(AttributeKey.longArrayKey(string), (T)ArrayBackedAttributesBuilder.toList(lArray));
    }

    default public AttributesBuilder put(String string, double ... dArray) {
        if (dArray == null) {
            return this;
        }
        return this.put(AttributeKey.doubleArrayKey(string), (T)ArrayBackedAttributesBuilder.toList(dArray));
    }

    default public AttributesBuilder put(String string, boolean ... blArray) {
        if (blArray == null) {
            return this;
        }
        return this.put(AttributeKey.booleanArrayKey(string), (T)ArrayBackedAttributesBuilder.toList(blArray));
    }

    public AttributesBuilder putAll(Attributes var1);

    default public <T> AttributesBuilder remove(AttributeKey<T> attributeKey) {
        return this;
    }

    default public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        return this;
    }
}

