/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.marshal;

import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonFactory;
import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonGenerator;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class JsonSerializer
extends Serializer {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonGenerator generator;

    JsonSerializer(OutputStream outputStream) throws IOException {
        this(JSON_FACTORY.createGenerator(outputStream));
    }

    JsonSerializer(JsonGenerator jsonGenerator) {
        this.generator = jsonGenerator;
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo protoFieldInfo, String string) throws IOException {
        this.generator.writeStringField(protoFieldInfo.getJsonName(), string);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo protoFieldInfo, String string) throws IOException {
        this.generator.writeStringField(protoFieldInfo.getJsonName(), string);
    }

    @Override
    public void writeBool(ProtoFieldInfo protoFieldInfo, boolean bl2) throws IOException {
        this.generator.writeBooleanField(protoFieldInfo.getJsonName(), bl2);
    }

    @Override
    protected void writeEnum(ProtoFieldInfo protoFieldInfo, ProtoEnumInfo protoEnumInfo) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), protoEnumInfo.getEnumNumber());
    }

    @Override
    protected void writeUint32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), n2);
    }

    @Override
    protected void writeSInt32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), n2);
    }

    @Override
    protected void writeint32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), n2);
    }

    @Override
    public void writeInt64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        this.generator.writeStringField(protoFieldInfo.getJsonName(), Long.toString(l2));
    }

    @Override
    protected void writeFixed64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        this.generator.writeStringField(protoFieldInfo.getJsonName(), Long.toString(l2));
    }

    @Override
    protected void writeFixed64Value(long l2) throws IOException {
        this.generator.writeString(Long.toString(l2));
    }

    @Override
    protected void writeUInt64Value(long l2) throws IOException {
        this.generator.writeString(Long.toString(l2));
    }

    @Override
    protected void writeFixed32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), n2);
    }

    @Override
    public void writeDouble(ProtoFieldInfo protoFieldInfo, double d2) throws IOException {
        this.generator.writeNumberField(protoFieldInfo.getJsonName(), d2);
    }

    @Override
    protected void writeDoubleValue(double d2) throws IOException {
        this.generator.writeNumber(d2);
    }

    @Override
    public void writeString(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        this.generator.writeFieldName(protoFieldInfo.getJsonName());
        this.generator.writeString(new String(byArray, StandardCharsets.UTF_8));
    }

    @Override
    protected void writeBytes(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        this.generator.writeBinaryField(protoFieldInfo.getJsonName(), byArray);
    }

    @Override
    protected void writeStartMessage(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeObjectFieldStart(protoFieldInfo.getJsonName());
    }

    @Override
    protected void writeEndMessage() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    protected void writeStartRepeatedPrimitive(ProtoFieldInfo protoFieldInfo, int n2, int n3) throws IOException {
        this.generator.writeArrayFieldStart(protoFieldInfo.getJsonName());
    }

    @Override
    protected void writeEndRepeatedPrimitive() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    protected void writeStartRepeatedVarint(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.generator.writeArrayFieldStart(protoFieldInfo.getJsonName());
    }

    @Override
    protected void writeEndRepeatedVarint() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo protoFieldInfo, Marshaler[] marshalerArray) throws IOException {
        this.generator.writeArrayFieldStart(protoFieldInfo.getJsonName());
        for (Marshaler marshaler : marshalerArray) {
            this.writeMessageValue(marshaler);
        }
        this.generator.writeEndArray();
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo protoFieldInfo, List<? extends Marshaler> list) throws IOException {
        this.generator.writeArrayFieldStart(protoFieldInfo.getJsonName());
        for (Marshaler marshaler : list) {
            this.writeMessageValue(marshaler);
        }
        this.generator.writeEndArray();
    }

    void writeMessageValue(Marshaler marshaler) throws IOException {
        this.generator.writeStartObject();
        marshaler.writeTo(this);
        this.generator.writeEndObject();
    }

    @Override
    public void writeSerializedMessage(byte[] byArray, String string) throws IOException {
        this.generator.writeRaw(string);
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }
}

