/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs;

import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.ReadWriteLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiLogRecordProcessor
implements LogRecordProcessor {
    private final List<LogRecordProcessor> logRecordProcessors;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static LogRecordProcessor create(List<LogRecordProcessor> list) {
        return new MultiLogRecordProcessor(new ArrayList<LogRecordProcessor>((Collection)Objects.requireNonNull(list, "logRecordProcessorsList")));
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord readWriteLogRecord) {
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            logRecordProcessor.onEmit(context, readWriteLogRecord);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            arrayList.add(logRecordProcessor.shutdown());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            arrayList.add(logRecordProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    private MultiLogRecordProcessor(List<LogRecordProcessor> list) {
        this.logRecordProcessors = list;
    }
}

