/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs.export;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.BatchLogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.LogRecordExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class BatchLogRecordProcessorBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 1000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final LogRecordExporter logRecordExporter;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(1000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();

    BatchLogRecordProcessorBuilder(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "delay must be non-negative");
        this.scheduleDelayNanos = timeUnit.toNanos(l2);
        return this;
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(Duration duration) {
        Objects.requireNonNull(duration, "delay");
        return this.setScheduleDelay(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.exporterTimeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        return this.setExporterTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchLogRecordProcessorBuilder setMaxQueueSize(int n2) {
        this.maxQueueSize = n2;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchLogRecordProcessorBuilder setMaxExportBatchSize(int n2) {
        Utils.checkArgument(n2 > 0, "maxExportBatchSize must be positive.");
        this.maxExportBatchSize = n2;
        return this;
    }

    public BatchLogRecordProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchLogRecordProcessor build() {
        return new BatchLogRecordProcessor(this.logRecordExporter, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

