/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.internal.ImmutableSpanContext;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanBuilder;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceFlags;
import com.contrastsecurity.thirdparty.iot.api.trace.TraceState;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.internal.AttributeUtil;
import com.contrastsecurity.thirdparty.iot.sdk.internal.AttributesMap;
import com.contrastsecurity.thirdparty.iot.sdk.trace.IdGenerator;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanLimits;
import com.contrastsecurity.thirdparty.iot.sdk.trace.TracerSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.trace.data.LinkData;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.SamplingDecision;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.SamplingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkSpanBuilder
implements SpanBuilder {
    private final String spanName;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final TracerSharedState tracerSharedState;
    private final SpanLimits spanLimits;
    @Nullable
    private Context parent;
    private SpanKind spanKind = SpanKind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<LinkData> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;

    SdkSpanBuilder(String string, InstrumentationScopeInfo instrumentationScopeInfo, TracerSharedState tracerSharedState, SpanLimits spanLimits) {
        this.spanName = string;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerSharedState = tracerSharedState;
        this.spanLimits = spanLimits;
    }

    @Override
    public SpanBuilder setParent(Context context) {
        if (context == null) {
            return this;
        }
        this.parent = context;
        return this;
    }

    @Override
    public SpanBuilder setNoParent() {
        this.parent = Context.root();
        return this;
    }

    @Override
    public SpanBuilder setSpanKind(SpanKind spanKind) {
        if (spanKind == null) {
            return this;
        }
        this.spanKind = spanKind;
        return this;
    }

    @Override
    public SpanBuilder addLink(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        this.addLink(LinkData.create(spanContext));
        return this;
    }

    @Override
    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int n2 = attributes.size();
        this.addLink(LinkData.create(spanContext, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerLink(), this.spanLimits.getMaxAttributeValueLength()), n2));
        return this;
    }

    private void addLink(LinkData linkData) {
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<LinkData>(this.spanLimits.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.spanLimits.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(linkData);
    }

    @Override
    public SpanBuilder setAttribute(String string, String string2) {
        return this.setAttribute(AttributeKey.stringKey(string), string2);
    }

    @Override
    public SpanBuilder setAttribute(String string, long l2) {
        return this.setAttribute(AttributeKey.longKey(string), Long.valueOf(l2));
    }

    @Override
    public SpanBuilder setAttribute(String string, double d2) {
        return this.setAttribute(AttributeKey.doubleKey(string), Double.valueOf(d2));
    }

    @Override
    public SpanBuilder setAttribute(String string, boolean bl2) {
        return this.setAttribute(AttributeKey.booleanKey(string), Boolean.valueOf(bl2));
    }

    @Override
    public <T> SpanBuilder setAttribute(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null || attributeKey.getKey().isEmpty() || t2 == null) {
            return this;
        }
        this.attributes().put(attributeKey, t2);
        return this;
    }

    @Override
    public SpanBuilder setStartTimestamp(long l2, TimeUnit timeUnit) {
        if (l2 < 0L || timeUnit == null) {
            return this;
        }
        this.startEpochNanos = timeUnit.toNanos(l2);
        return this;
    }

    @Override
    public Span startSpan() {
        Context context = this.parent == null ? Context.current() : this.parent;
        Span span = Span.fromContext(context);
        SpanContext spanContext = span.getSpanContext();
        IdGenerator idGenerator = this.tracerSharedState.getIdGenerator();
        String string = idGenerator.generateSpanId();
        String string2 = !spanContext.isValid() ? idGenerator.generateTraceId() : spanContext.getTraceId();
        List<LinkData> list = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Attributes attributes = this.attributes == null ? Attributes.empty() : this.attributes;
        SamplingResult samplingResult = this.tracerSharedState.getSampler().shouldSample(context, string2, this.spanName, this.spanKind, attributes, list);
        SamplingDecision samplingDecision = samplingResult.getDecision();
        TraceState traceState = samplingResult.getUpdatedTraceState(spanContext.getTraceState());
        SpanContext spanContext2 = ImmutableSpanContext.create(string2, string, SdkSpanBuilder.isSampled(samplingDecision) ? TraceFlags.getSampled() : TraceFlags.getDefault(), traceState, false, this.tracerSharedState.isIdGeneratorSafeToSkipIdValidation());
        if (!SdkSpanBuilder.isRecording(samplingDecision)) {
            return Span.wrap(spanContext2);
        }
        Attributes attributes2 = samplingResult.getAttributes();
        if (!attributes2.isEmpty()) {
            attributes2.forEach((attributeKey, object) -> this.attributes().put(attributeKey, object));
        }
        AttributesMap attributesMap = this.attributes;
        this.attributes = null;
        return SdkSpan.startSpan(spanContext2, this.spanName, this.instrumentationScopeInfo, this.spanKind, span, context, this.spanLimits, this.tracerSharedState.getActiveSpanProcessor(), this.tracerSharedState.getClock(), this.tracerSharedState.getResource(), attributesMap, list, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private AttributesMap attributes() {
        AttributesMap attributesMap = this.attributes;
        if (attributesMap == null) {
            attributesMap = this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
        }
        return attributesMap;
    }

    static boolean isRecording(SamplingDecision samplingDecision) {
        return SamplingDecision.RECORD_ONLY.equals((Object)samplingDecision) || SamplingDecision.RECORD_AND_SAMPLE.equals((Object)samplingDecision);
    }

    static boolean isSampled(SamplingDecision samplingDecision) {
        return SamplingDecision.RECORD_AND_SAMPLE.equals((Object)samplingDecision);
    }
}

