/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nn3nx;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.nn3nx.CDATAReader;
import com.contrastsecurity.thirdparty.nn3nx.ContentReader;
import com.contrastsecurity.thirdparty.nn3nx.IXMLBuilder;
import com.contrastsecurity.thirdparty.nn3nx.IXMLEntityResolver;
import com.contrastsecurity.thirdparty.nn3nx.IXMLParser;
import com.contrastsecurity.thirdparty.nn3nx.IXMLReader;
import com.contrastsecurity.thirdparty.nn3nx.IXMLValidator;
import com.contrastsecurity.thirdparty.nn3nx.PIReader;
import com.contrastsecurity.thirdparty.nn3nx.XMLEntityResolver;
import com.contrastsecurity.thirdparty.nn3nx.XMLException;
import com.contrastsecurity.thirdparty.nn3nx.XMLUtil;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class StdXMLParser
implements IXMLParser {
    private IXMLBuilder builder = null;
    private IXMLReader reader = null;
    private IXMLEntityResolver entityResolver = new XMLEntityResolver();
    private IXMLValidator validator = null;

    @Override
    public void setBuilder(IXMLBuilder iXMLBuilder) {
        this.builder = iXMLBuilder;
    }

    @Override
    public IXMLBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void setValidator(IXMLValidator iXMLValidator) {
        this.validator = iXMLValidator;
    }

    @Override
    public IXMLValidator getValidator() {
        return this.validator;
    }

    @Override
    public void setResolver(IXMLEntityResolver iXMLEntityResolver) {
        this.entityResolver = iXMLEntityResolver;
    }

    @Override
    public IXMLEntityResolver getResolver() {
        return this.entityResolver;
    }

    @Override
    public void setReader(IXMLReader iXMLReader) {
        this.reader = iXMLReader;
    }

    @Override
    public IXMLReader getReader() {
        return this.reader;
    }

    @Override
    public Object parse() throws XMLException {
        try {
            this.builder.startBuilding(this.reader.getSystemID(), this.reader.getLineNr());
            this.scanData();
            return this.builder.getResult();
        }
        catch (XMLException xMLException) {
            throw xMLException;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new XMLException(exception2);
        }
    }

    protected void scanData() throws Exception {
        block4: while (!this.reader.atEOF() && this.builder.getResult() == null) {
            String string = XMLUtil.read(this.reader, '&');
            char c2 = string.charAt(0);
            if (c2 == '&') {
                XMLUtil.processEntity(string, this.reader, this.entityResolver);
                continue;
            }
            switch (c2) {
                case '<': {
                    this.scanSomeTag(false, null, new Properties());
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
            }
            XMLUtil.errorInvalidInput(this.reader.getSystemID(), this.reader.getLineNr(), "`" + c2 + "' (0x" + Integer.toHexString(c2) + ')');
        }
    }

    protected void scanSomeTag(boolean bl2, String string, Properties properties) throws Exception {
        String string2 = XMLUtil.read(this.reader, '&');
        char c2 = string2.charAt(0);
        if (c2 == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string2);
        }
        switch (c2) {
            case '?': {
                this.processPI();
                break;
            }
            case '!': {
                this.processSpecialTag(bl2);
                break;
            }
            default: {
                this.reader.unread(c2);
                this.processElement(string, properties);
            }
        }
    }

    protected void processPI() throws Exception {
        XMLUtil.skipWhitespace(this.reader, null);
        String string = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        PIReader pIReader = new PIReader(this.reader);
        if (!string.equalsIgnoreCase("xml")) {
            this.builder.newProcessingInstruction(string, pIReader);
        }
        ((Reader)pIReader).close();
    }

    protected void processSpecialTag(boolean bl2) throws Exception {
        String string = XMLUtil.read(this.reader, '&');
        char c2 = string.charAt(0);
        if (c2 == '&') {
            XMLUtil.errorUnexpectedEntity(this.reader.getSystemID(), this.reader.getLineNr(), string);
        }
        switch (c2) {
            case '[': {
                if (bl2) {
                    this.processCDATA();
                } else {
                    XMLUtil.errorUnexpectedCDATA(this.reader.getSystemID(), this.reader.getLineNr());
                }
                return;
            }
            case 'D': {
                this.processDocType();
                return;
            }
            case '-': {
                XMLUtil.skipComment(this.reader);
                return;
            }
        }
    }

    protected void processCDATA() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "CDATA[")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<![[CDATA[");
        }
        this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
        CDATAReader cDATAReader = new CDATAReader(this.reader);
        this.builder.addPCData(cDATAReader, this.reader.getSystemID(), this.reader.getLineNr());
        ((Reader)cDATAReader).close();
    }

    protected void processDocType() throws Exception {
        if (!XMLUtil.checkLiteral(this.reader, "OCTYPE")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "<!DOCTYPE");
            return;
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        char c2 = this.reader.read();
        if (c2 == 'P') {
            string = XMLUtil.scanPublicID(stringBuffer, this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c2 = this.reader.read();
        } else if (c2 == 'S') {
            string = XMLUtil.scanSystemID(this.reader);
            XMLUtil.skipWhitespace(this.reader, null);
            c2 = this.reader.read();
        }
        if (c2 == '[') {
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, false);
            XMLUtil.skipWhitespace(this.reader, null);
            c2 = this.reader.read();
        }
        if (c2 != '>') {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
        }
        if (string != null) {
            Reader reader = this.reader.openStream(stringBuffer.toString(), string);
            this.reader.startNewStream(reader);
            this.reader.setSystemID(string);
            this.reader.setPublicID(stringBuffer.toString());
            this.validator.parseDTD(stringBuffer.toString(), this.reader, this.entityResolver, true);
        }
    }

    protected void processElement(String string, Properties properties) throws Exception {
        String string2;
        Object object;
        int n2;
        String string3;
        char c2;
        String string4;
        String string5 = string4 = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        String string6 = null;
        int n3 = string5.indexOf(58);
        if (n3 > 0) {
            string6 = string5.substring(0, n3);
            string5 = string5.substring(n3 + 1);
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.validator.elementStarted(string4, this.reader.getSystemID(), this.reader.getLineNr());
        while ((c2 = this.reader.read()) != '/' && c2 != '>') {
            this.reader.unread(c2);
            this.processAttribute(vector, vector2, vector3);
            XMLUtil.skipWhitespace(this.reader, null);
        }
        Properties properties2 = new Properties();
        this.validator.elementAttributesProcessed(string4, properties2, this.reader.getSystemID(), this.reader.getLineNr());
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string7 = (String)enumeration.nextElement();
            string3 = properties2.getProperty(string7);
            vector.addElement(string7);
            vector2.addElement(string3);
            vector3.addElement("CDATA");
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            string3 = (String)vector.elementAt(n2);
            object = (String)vector2.elementAt(n2);
            string2 = (String)vector3.elementAt(n2);
            if (string3.equals("xmlns")) {
                string = object;
                continue;
            }
            if (!string3.startsWith("xmlns:")) continue;
            properties.put(string3.substring(6), object);
        }
        if (string6 == null) {
            this.builder.startElement(string5, string6, string, this.reader.getSystemID(), this.reader.getLineNr());
        } else {
            this.builder.startElement(string5, string6, properties.getProperty(string6), this.reader.getSystemID(), this.reader.getLineNr());
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            string3 = (String)vector.elementAt(n2);
            if (string3.startsWith("xmlns")) continue;
            object = (String)vector2.elementAt(n2);
            string2 = (String)vector3.elementAt(n2);
            n3 = string3.indexOf(58);
            if (n3 > 0) {
                String string8 = string3.substring(0, n3);
                string3 = string3.substring(n3 + 1);
                this.builder.addAttribute(string3, string8, properties.getProperty(string8), (String)object, string2);
                continue;
            }
            this.builder.addAttribute(string3, null, null, (String)object, string2);
        }
        if (string6 == null) {
            this.builder.elementAttributesProcessed(string5, string6, string);
        } else {
            this.builder.elementAttributesProcessed(string5, string6, properties.getProperty(string6));
        }
        if (c2 == '/') {
            if (this.reader.read() != '>') {
                XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`>'");
            }
            this.validator.elementEnded(string5, this.reader.getSystemID(), this.reader.getLineNr());
            if (string6 == null) {
                this.builder.endElement(string5, string6, string);
            } else {
                this.builder.endElement(string5, string6, properties.getProperty(string6));
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        while (true) {
            stringBuffer.setLength(0);
            while (true) {
                XMLUtil.skipWhitespace(this.reader, stringBuffer);
                string3 = XMLUtil.read(this.reader, '&');
                if (string3.charAt(0) != '&' || string3.charAt(1) == '#') break;
                XMLUtil.processEntity(string3, this.reader, this.entityResolver);
            }
            if (string3.charAt(0) == '<') {
                string3 = XMLUtil.read(this.reader, '\u0000');
                if (string3.charAt(0) == '/') {
                    XMLUtil.skipWhitespace(this.reader, null);
                    string3 = XMLUtil.scanIdentifier(this.reader);
                    if (!string3.equals(string4)) {
                        XMLUtil.errorWrongClosingTag(this.reader.getSystemID(), this.reader.getLineNr(), string5, string3);
                    }
                    XMLUtil.skipWhitespace(this.reader, null);
                    if (this.reader.read() != '>') {
                        XMLUtil.errorClosingTagNotEmpty(this.reader.getSystemID(), this.reader.getLineNr());
                    }
                    this.validator.elementEnded(string4, this.reader.getSystemID(), this.reader.getLineNr());
                    if (string6 == null) {
                        this.builder.endElement(string5, string6, string);
                        break;
                    }
                    this.builder.endElement(string5, string6, properties.getProperty(string6));
                    break;
                }
                this.reader.unread(string3.charAt(0));
                this.scanSomeTag(true, string, (Properties)properties.clone());
                continue;
            }
            if (string3.charAt(0) == '&') {
                c2 = XMLUtil.processCharLiteral(string3);
                stringBuffer.append(c2);
            } else {
                this.reader.unread(string3.charAt(0));
            }
            this.validator.PCDataAdded(this.reader.getSystemID(), this.reader.getLineNr());
            object = new ContentReader(this.reader, this.entityResolver, stringBuffer.toString());
            this.builder.addPCData((Reader)object, this.reader.getSystemID(), this.reader.getLineNr());
            ((Reader)object).close();
        }
    }

    protected void processAttribute(Vector vector, Vector vector2, Vector vector3) throws Exception {
        String string = XMLUtil.scanIdentifier(this.reader);
        XMLUtil.skipWhitespace(this.reader, null);
        if (!XMLUtil.read(this.reader, '&').equals("=")) {
            XMLUtil.errorExpectedInput(this.reader.getSystemID(), this.reader.getLineNr(), "`='");
        }
        XMLUtil.skipWhitespace(this.reader, null);
        String string2 = XMLUtil.scanString(this.reader, '&', this.entityResolver);
        vector.addElement(string);
        vector2.addElement(string2);
        vector3.addElement("CDATA");
        this.validator.attributeAdded(string, string2, this.reader.getSystemID(), this.reader.getLineNr());
    }
}

