/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.parser;

import com.contrastsecurity.thirdparty.nsjsqlp.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(ParseException.initialise(token, nArray, stringArray));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String initialise(Token token, int[][] nArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 < nArray[i2].length) {
                n2 = nArray[i2].length;
            }
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                stringBuffer.append(stringArray[nArray[i2][i3]]).append(' ');
            }
            if (nArray[i2][nArray[i2].length - 1] != 0) {
                stringBuffer.append("...");
            }
            stringBuffer.append(EOL).append("    ");
        }
        String string = "Encountered \"";
        Token token2 = token.next;
        for (int i4 = 0; i4 < n2; ++i4) {
            if (i4 != 0) {
                string = string + " ";
            }
            if (token2.kind == 0) {
                string = string + stringArray[0];
                break;
            }
            string = string + " " + stringArray[token2.kind];
            string = string + " \"";
            string = string + ParseException.add_escapes(token2.image);
            string = string + " \"";
            token2 = token2.next;
        }
        string = string + "\" at line " + token.next.beginLine + ", column " + token.next.beginColumn;
        string = string + "." + EOL;
        if (nArray.length != 0) {
            string = nArray.length == 1 ? string + "Was expecting:" + EOL + "    " : string + "Was expecting one of:" + EOL + "    ";
            string = string + stringBuffer.toString();
        }
        return string;
    }

    static String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block10: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    char c2 = string.charAt(i2);
                    if (c2 < ' ' || c2 > '~') {
                        String string2 = "0000" + Integer.toString(c2, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block10;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

