/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.io.output;

import com.contrastsecurity.thirdparty.oa4j.commons.io.input.ClosedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ByteArrayOutputStream
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    private int count;
    private boolean reuseBuffers = true;

    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.needNewBuffer(n2);
        }
    }

    private void needNewBuffer(int n2) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            int n3;
            if (this.currentBuffer == null) {
                n3 = n2;
                this.filledBufferSum = 0;
            } else {
                n3 = Math.max(this.currentBuffer.length << 1, n2 - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = new byte[n3];
            this.buffers.add(this.currentBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            int n4 = this.count + n3;
            int n5 = n3;
            int n6 = this.count - this.filledBufferSum;
            while (n5 > 0) {
                int n7 = Math.min(n5, this.currentBuffer.length - n6);
                System.arraycopy(byArray, n2 + n3 - n5, this.currentBuffer, n6, n7);
                if ((n5 -= n7) <= 0) continue;
                this.needNewBuffer(n4);
                n6 = 0;
            }
            this.count = n4;
        }
    }

    @Override
    public synchronized void write(int n2) {
        int n3 = this.count - this.filledBufferSum;
        if (n3 == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
            n3 = 0;
        }
        this.currentBuffer[n3] = (byte)n2;
        ++this.count;
    }

    public synchronized int write(InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = this.count - this.filledBufferSum;
        int n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
        while (n4 != -1) {
            n2 += n4;
            this.count += n4;
            if ((n3 += n4) == this.currentBuffer.length) {
                this.needNewBuffer(this.currentBuffer.length);
                n3 = 0;
            }
            n4 = inputStream.read(this.currentBuffer, n3, this.currentBuffer.length - n3);
        }
        return n2;
    }

    public synchronized int size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        if (this.reuseBuffers) {
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
        } else {
            this.currentBuffer = null;
            int n2 = this.buffers.get(0).length;
            this.buffers.clear();
            this.needNewBuffer(n2);
            this.reuseBuffers = true;
        }
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        int n2 = this.count;
        for (byte[] byArray : this.buffers) {
            int n3 = Math.min(byArray.length, n2);
            outputStream.write(byArray, 0, n3);
            if ((n2 -= n3) != 0) continue;
            break;
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byteArrayOutputStream.write(inputStream);
        return byteArrayOutputStream.toInputStream();
    }

    public synchronized InputStream toInputStream() {
        int n2 = this.count;
        if (n2 == 0) {
            return new ClosedInputStream();
        }
        ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>(this.buffers.size());
        for (byte[] byArray : this.buffers) {
            int n3 = Math.min(byArray.length, n2);
            arrayList.add(new ByteArrayInputStream(byArray, 0, n3));
            if ((n2 -= n3) != 0) continue;
            break;
        }
        this.reuseBuffers = false;
        return new SequenceInputStream(Collections.enumeration(arrayList));
    }

    public synchronized byte[] toByteArray() {
        int n2 = this.count;
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this.buffers) {
            int n4 = Math.min(byArray2.length, n2);
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
            if ((n2 -= n4) != 0) continue;
            break;
        }
        return byArray;
    }

    @Deprecated
    public String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }
}

