/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.client;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.HttpEntity;
import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.ClientProtocolException;
import com.contrastsecurity.thirdparty.oa4j.http.client.HttpClient;
import com.contrastsecurity.thirdparty.oa4j.http.client.ResponseHandler;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.CloseableHttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.oa4j.http.client.utils.URIUtils;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpClient
implements HttpClient,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    @Override
    public CloseableHttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.doExecute(httpHost, httpRequest, httpContext);
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        Args.notNull(httpUriRequest, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(httpUriRequest), httpUriRequest, httpContext);
    }

    private static HttpHost determineTarget(HttpUriRequest httpUriRequest) throws ClientProtocolException {
        HttpHost httpHost = null;
        URI uRI = httpUriRequest.getURI();
        if (uRI.isAbsolute() && (httpHost = URIUtils.extractHost(uRI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + uRI);
        }
        return httpHost;
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        return this.execute(httpUriRequest, (HttpContext)null);
    }

    @Override
    public CloseableHttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException, ClientProtocolException {
        return this.doExecute(httpHost, httpRequest, null);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(httpUriRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        HttpHost httpHost = CloseableHttpClient.determineTarget(httpUriRequest);
        return this.execute(httpHost, httpUriRequest, responseHandler, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(httpHost, httpRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        Args.notNull(responseHandler, "Response handler");
        CloseableHttpResponse closeableHttpResponse = this.execute(httpHost, httpRequest, httpContext);
        try {
            T t2 = responseHandler.handleResponse(closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            EntityUtils.consume(httpEntity);
            T t3 = t2;
            return t3;
        }
        catch (ClientProtocolException clientProtocolException) {
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            try {
                EntityUtils.consume(httpEntity);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                this.log.warn("Error consuming content after an exception.", exception2);
            }
            throw clientProtocolException;
        }
        finally {
            closeableHttpResponse.close();
        }
    }
}

