/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.execchain;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.Header;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.ServiceUnavailableRetryStrategy;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.CloseableHttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpExecutionAware;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpRequestWrapper;
import com.contrastsecurity.thirdparty.oa4j.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.oa4j.http.impl.execchain.ClientExecChain;
import com.contrastsecurity.thirdparty.oa4j.http.impl.execchain.RequestEntityProxy;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain clientExecChain, ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        Args.notNull(clientExecChain, "HTTP request executor");
        Args.notNull(serviceUnavailableRetryStrategy, "Retry strategy");
        this.requestExecutor = clientExecChain;
        this.retryStrategy = serviceUnavailableRetryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n2 = 1;
        while (true) {
            CloseableHttpResponse closeableHttpResponse = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            try {
                if (this.retryStrategy.retryRequest(closeableHttpResponse, n2, httpClientContext) && RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                    closeableHttpResponse.close();
                    long l2 = this.retryStrategy.getRetryInterval();
                    if (l2 > 0L) {
                        try {
                            this.log.trace("Wait for " + l2);
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return closeableHttpResponse;
                }
                httpRequestWrapper.setHeaders(headerArray);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                closeableHttpResponse.close();
                throw runtimeException2;
            }
            ++n2;
        }
    }
}

