/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.message;

import com.contrastsecurity.thirdparty.oa4j.http.HeaderElement;
import com.contrastsecurity.thirdparty.oa4j.http.NameValuePair;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.message.HeaderValueFormatter;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    @Deprecated
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static String formatElements(HeaderElement[] headerElementArray, boolean bl2, HeaderValueFormatter headerValueFormatter) {
        return (headerValueFormatter != null ? headerValueFormatter : INSTANCE).formatElements(null, headerElementArray, bl2).toString();
    }

    @Override
    public CharArrayBuffer formatElements(CharArrayBuffer charArrayBuffer, HeaderElement[] headerElementArray, boolean bl2) {
        Args.notNull(headerElementArray, "Header element array");
        int n2 = this.estimateElementsLen(headerElementArray);
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        if (charArrayBuffer2 == null) {
            charArrayBuffer2 = new CharArrayBuffer(n2);
        } else {
            charArrayBuffer2.ensureCapacity(n2);
        }
        for (int i2 = 0; i2 < headerElementArray.length; ++i2) {
            if (i2 > 0) {
                charArrayBuffer2.append(", ");
            }
            this.formatHeaderElement(charArrayBuffer2, headerElementArray[i2], bl2);
        }
        return charArrayBuffer2;
    }

    protected int estimateElementsLen(HeaderElement[] headerElementArray) {
        if (headerElementArray == null || headerElementArray.length < 1) {
            return 0;
        }
        int n2 = (headerElementArray.length - 1) * 2;
        for (HeaderElement headerElement : headerElementArray) {
            n2 += this.estimateHeaderElementLen(headerElement);
        }
        return n2;
    }

    public static String formatHeaderElement(HeaderElement headerElement, boolean bl2, HeaderValueFormatter headerValueFormatter) {
        return (headerValueFormatter != null ? headerValueFormatter : INSTANCE).formatHeaderElement(null, headerElement, bl2).toString();
    }

    @Override
    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charArrayBuffer, HeaderElement headerElement, boolean bl2) {
        int n2;
        Args.notNull(headerElement, "Header element");
        int n3 = this.estimateHeaderElementLen(headerElement);
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        if (charArrayBuffer2 == null) {
            charArrayBuffer2 = new CharArrayBuffer(n3);
        } else {
            charArrayBuffer2.ensureCapacity(n3);
        }
        charArrayBuffer2.append(headerElement.getName());
        String string = headerElement.getValue();
        if (string != null) {
            charArrayBuffer2.append('=');
            this.doFormatValue(charArrayBuffer2, string, bl2);
        }
        if ((n2 = headerElement.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                charArrayBuffer2.append("; ");
                this.formatNameValuePair(charArrayBuffer2, headerElement.getParameter(i2), bl2);
            }
        }
        return charArrayBuffer2;
    }

    protected int estimateHeaderElementLen(HeaderElement headerElement) {
        int n2;
        if (headerElement == null) {
            return 0;
        }
        int n3 = headerElement.getName().length();
        String string = headerElement.getValue();
        if (string != null) {
            n3 += 3 + string.length();
        }
        if ((n2 = headerElement.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += 2 + this.estimateNameValuePairLen(headerElement.getParameter(i2));
            }
        }
        return n3;
    }

    public static String formatParameters(NameValuePair[] nameValuePairArray, boolean bl2, HeaderValueFormatter headerValueFormatter) {
        return (headerValueFormatter != null ? headerValueFormatter : INSTANCE).formatParameters(null, nameValuePairArray, bl2).toString();
    }

    @Override
    public CharArrayBuffer formatParameters(CharArrayBuffer charArrayBuffer, NameValuePair[] nameValuePairArray, boolean bl2) {
        Args.notNull(nameValuePairArray, "Header parameter array");
        int n2 = this.estimateParametersLen(nameValuePairArray);
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        if (charArrayBuffer2 == null) {
            charArrayBuffer2 = new CharArrayBuffer(n2);
        } else {
            charArrayBuffer2.ensureCapacity(n2);
        }
        for (int i2 = 0; i2 < nameValuePairArray.length; ++i2) {
            if (i2 > 0) {
                charArrayBuffer2.append("; ");
            }
            this.formatNameValuePair(charArrayBuffer2, nameValuePairArray[i2], bl2);
        }
        return charArrayBuffer2;
    }

    protected int estimateParametersLen(NameValuePair[] nameValuePairArray) {
        if (nameValuePairArray == null || nameValuePairArray.length < 1) {
            return 0;
        }
        int n2 = (nameValuePairArray.length - 1) * 2;
        for (NameValuePair nameValuePair : nameValuePairArray) {
            n2 += this.estimateNameValuePairLen(nameValuePair);
        }
        return n2;
    }

    public static String formatNameValuePair(NameValuePair nameValuePair, boolean bl2, HeaderValueFormatter headerValueFormatter) {
        return (headerValueFormatter != null ? headerValueFormatter : INSTANCE).formatNameValuePair(null, nameValuePair, bl2).toString();
    }

    @Override
    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charArrayBuffer, NameValuePair nameValuePair, boolean bl2) {
        Args.notNull(nameValuePair, "Name / value pair");
        int n2 = this.estimateNameValuePairLen(nameValuePair);
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        if (charArrayBuffer2 == null) {
            charArrayBuffer2 = new CharArrayBuffer(n2);
        } else {
            charArrayBuffer2.ensureCapacity(n2);
        }
        charArrayBuffer2.append(nameValuePair.getName());
        String string = nameValuePair.getValue();
        if (string != null) {
            charArrayBuffer2.append('=');
            this.doFormatValue(charArrayBuffer2, string, bl2);
        }
        return charArrayBuffer2;
    }

    protected int estimateNameValuePairLen(NameValuePair nameValuePair) {
        if (nameValuePair == null) {
            return 0;
        }
        int n2 = nameValuePair.getName().length();
        String string = nameValuePair.getValue();
        if (string != null) {
            n2 += 3 + string.length();
        }
        return n2;
    }

    protected void doFormatValue(CharArrayBuffer charArrayBuffer, String string, boolean bl2) {
        int n2;
        boolean bl3 = bl2;
        if (!bl3) {
            for (n2 = 0; n2 < string.length() && !bl3; ++n2) {
                bl3 = this.isSeparator(string.charAt(n2));
            }
        }
        if (bl3) {
            charArrayBuffer.append('\"');
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (this.isUnsafe(c2)) {
                charArrayBuffer.append('\\');
            }
            charArrayBuffer.append(c2);
        }
        if (bl3) {
            charArrayBuffer.append('\"');
        }
    }

    protected boolean isSeparator(char c2) {
        return SEPARATORS.indexOf(c2) >= 0;
    }

    protected boolean isUnsafe(char c2) {
        return UNSAFE_CHARS.indexOf(c2) >= 0;
    }
}

