/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.ByteBufferDestinationHelper;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class OutputStreamManager
extends AbstractManager
implements ByteBufferDestination {
    protected final Layout<?> layout;
    protected ByteBuffer byteBuffer;
    private volatile OutputStream outputStream;
    private boolean skipFooter;

    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2) {
        this(outputStream, string, layout, bl2, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2, int n2) {
        this(outputStream, string, layout, bl2, ByteBuffer.wrap(new byte[n2]));
    }

    @Deprecated
    protected OutputStreamManager(OutputStream outputStream, String string, Layout<?> layout, boolean bl2, ByteBuffer byteBuffer) {
        super(null, string);
        this.outputStream = outputStream;
        this.layout = layout;
        if (bl2) {
            this.writeHeader(outputStream);
        }
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
    }

    protected OutputStreamManager(LoggerContext loggerContext, OutputStream outputStream, String string, boolean bl2, Layout<? extends Serializable> layout, boolean bl3, ByteBuffer byteBuffer) {
        super(loggerContext, string);
        if (bl2 && outputStream != null) {
            LOGGER.error("Invalid OutputStreamManager configuration for '{}': You cannot both set the OutputStream and request on-demand.", (Object)string);
        }
        this.layout = layout;
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
        this.outputStream = outputStream;
        if (bl3) {
            this.writeHeader(outputStream);
        }
    }

    public static <T> OutputStreamManager getManager(String string, T t2, ManagerFactory<? extends OutputStreamManager, T> managerFactory) {
        return AbstractManager.getManager(string, managerFactory, t2);
    }

    protected OutputStream createOutputStream() throws IOException {
        throw new IllegalStateException(this.getClass().getCanonicalName() + " must implement createOutputStream()");
    }

    public void skipFooter(boolean bl2) {
        this.skipFooter = bl2;
    }

    @Override
    public boolean releaseSub(long l2, TimeUnit timeUnit) {
        this.writeFooter();
        return this.closeOutputStream();
    }

    protected void writeHeader(OutputStream outputStream) {
        byte[] byArray;
        if (this.layout != null && outputStream != null && (byArray = this.layout.getHeader()) != null) {
            try {
                outputStream.write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                this.logError("Unable to write header", iOException);
            }
        }
    }

    protected void writeFooter() {
        if (this.layout == null || this.skipFooter) {
            return;
        }
        byte[] byArray = this.layout.getFooter();
        if (byArray != null) {
            this.write(byArray);
        }
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    public boolean hasOutputStream() {
        return this.outputStream != null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.createOutputStream();
        }
        return this.outputStream;
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length, false);
    }

    protected void write(byte[] byArray, boolean bl2) {
        this.write(byArray, 0, byArray.length, bl2);
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) {
        this.write(byArray, n2, n3, false);
    }

    protected void write(byte[] byArray, int n2, int n3) {
        this.writeBytes(byArray, n2, n3);
    }

    protected synchronized void write(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2 && this.byteBuffer.position() == 0) {
            this.writeToDestination(byArray, n2, n3);
            this.flushDestination();
            return;
        }
        if (n3 >= this.byteBuffer.capacity()) {
            this.flush();
            this.writeToDestination(byArray, n2, n3);
        } else {
            if (n3 > this.byteBuffer.remaining()) {
                this.flush();
            }
            this.byteBuffer.put(byArray, n2, n3);
        }
        if (bl2) {
            this.flush();
        }
    }

    protected synchronized void writeToDestination(byte[] byArray, int n2, int n3) {
        try {
            this.getOutputStream().write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AppenderLoggingException("Error writing to stream " + this.getName(), iOException);
        }
    }

    protected synchronized void flushDestination() {
        OutputStream outputStream = this.outputStream;
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw new AppenderLoggingException("Error flushing stream " + this.getName(), iOException);
            }
        }
    }

    protected synchronized void flushBuffer(ByteBuffer byteBuffer) {
        ((Buffer)byteBuffer).flip();
        try {
            if (byteBuffer.remaining() > 0) {
                this.writeToDestination(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            }
        }
        finally {
            byteBuffer.clear();
        }
    }

    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
        this.flushDestination();
    }

    protected synchronized boolean closeOutputStream() {
        this.flush();
        OutputStream outputStream = this.outputStream;
        if (outputStream == null || outputStream == System.out || outputStream == System.err) {
            return true;
        }
        try {
            outputStream.close();
            LOGGER.debug("OutputStream closed");
        }
        catch (IOException iOException) {
            this.logError("Unable to close stream", iOException);
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer byteBuffer) {
        this.flushBuffer(byteBuffer);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return;
        }
        OutputStreamManager outputStreamManager = this;
        synchronized (outputStreamManager) {
            ByteBufferDestinationHelper.writeToUnsynchronized(byteBuffer, this);
        }
    }
}

