/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.ConfigurationListener;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.AbstractWatcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.FileWatcher;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Source;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Watcher;
import java.io.File;
import java.util.List;

public class ConfigurationFileWatcher
extends AbstractWatcher
implements FileWatcher {
    private File file;
    private long lastModifiedMillis;

    public ConfigurationFileWatcher(Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        super(configuration, reconfigurable, list);
        this.lastModifiedMillis = l2;
    }

    @Override
    public long getLastModified() {
        return this.file != null ? this.file.lastModified() : 0L;
    }

    @Override
    public void fileModified(File file) {
        this.lastModifiedMillis = file.lastModified();
    }

    @Override
    public void watching(Source source) {
        this.file = source.getFile();
        this.lastModifiedMillis = this.file.lastModified();
        super.watching(source);
    }

    @Override
    public boolean isModified() {
        return this.lastModifiedMillis != this.file.lastModified();
    }

    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> list, long l2) {
        ConfigurationFileWatcher configurationFileWatcher = new ConfigurationFileWatcher(this.getConfiguration(), reconfigurable, list, l2);
        if (this.getSource() != null) {
            configurationFileWatcher.watching(this.getSource());
        }
        return configurationFileWatcher;
    }
}

