/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.AnsiConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.AnsiEscape;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Plugin(name="highlight", category="Converter")
@ConverterKeys(value={"highlight"})
@PerformanceSensitive(value={"allocation"})
public final class HighlightConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private static final Map<String, String> DEFAULT_STYLES = new HashMap<String, String>();
    private static final Map<String, String> LOGBACK_STYLES = new HashMap<String, String>();
    private static final String STYLE_KEY = "STYLE";
    private static final String STYLE_KEY_DEFAULT = "DEFAULT";
    private static final String STYLE_KEY_LOGBACK = "LOGBACK";
    private static final Map<String, Map<String, String>> STYLES = new HashMap<String, Map<String, String>>();
    private final Map<String, String> levelStyles;
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String defaultStyle;

    private static Map<String, String> createLevelStyleMap(String[] stringArray) {
        if (stringArray.length < 2) {
            return DEFAULT_STYLES;
        }
        String string = stringArray[1].replaceAll("disableAnsi=(true|false)", "").replaceAll("noConsoleNoAnsi=(true|false)", "");
        Map<String, String> map = AnsiEscape.createMap(string, new String[]{STYLE_KEY});
        HashMap<String, String> hashMap = new HashMap<String, String>(DEFAULT_STYLES);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Object object;
            String string2 = entry.getKey().toUpperCase(Locale.ENGLISH);
            String string3 = entry.getValue();
            if (STYLE_KEY.equalsIgnoreCase(string2)) {
                object = STYLES.get(string3.toUpperCase(Locale.ENGLISH));
                if (object == null) {
                    LOGGER.error("Unknown level style: " + string3 + ". Use one of " + Arrays.toString(STYLES.keySet().toArray()));
                    continue;
                }
                hashMap.putAll((Map<String, String>)object);
                continue;
            }
            object = Level.toLevel(string2, null);
            if (object == null) {
                LOGGER.warn("Setting style for yet unknown level name {}", (Object)string2);
                hashMap.put(string2, string3);
                continue;
            }
            hashMap.put(((Level)object).name(), string3);
        }
        return hashMap;
    }

    public static HighlightConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        boolean bl2 = Arrays.toString(stringArray).contains("disableAnsi=true");
        boolean bl3 = Arrays.toString(stringArray).contains("noConsoleNoAnsi=true");
        boolean bl4 = bl2 || bl3 && System.console() == null;
        return new HighlightConverter(list, HighlightConverter.createLevelStyleMap(stringArray), bl4);
    }

    private HighlightConverter(List<PatternFormatter> list, Map<String, String> map, boolean bl2) {
        super("style", "style");
        this.patternFormatters = list;
        this.levelStyles = map;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = bl2;
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        String string = this.levelStyles.get(logEvent.getLevel().name());
        if (!this.noAnsi) {
            n3 = stringBuilder.length();
            if (string != null) {
                stringBuilder.append(string);
            }
            n4 = stringBuilder.length();
        }
        int n5 = this.patternFormatters.size();
        for (n2 = 0; n2 < n5; ++n2) {
            this.patternFormatters.get(n2).format(logEvent, stringBuilder);
        }
        int n6 = n2 = stringBuilder.length() == n4 ? 1 : 0;
        if (!this.noAnsi) {
            if (n2 != 0) {
                stringBuilder.setLength(n3);
            } else if (string != null) {
                stringBuilder.append(this.defaultStyle);
            }
        }
    }

    String getLevelStyle(Level level) {
        return this.levelStyles.get(level.name());
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter patternFormatter : this.patternFormatters) {
            if (!patternFormatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("YELLOW"));
        DEFAULT_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("GREEN"));
        DEFAULT_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence("CYAN"));
        DEFAULT_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence("BLACK"));
        LOGBACK_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BLINK", "BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("RED"));
        LOGBACK_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("BLUE"));
        LOGBACK_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence(null));
        LOGBACK_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence(null));
        STYLES.put(STYLE_KEY_DEFAULT, DEFAULT_STYLES);
        STYLES.put(STYLE_KEY_LOGBACK, LOGBACK_STYLES);
    }
}

