/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.ArrayUtils;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;

public final class NetUtils {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String UNKNOWN_LOCALHOST = "UNKNOWN_LOCALHOST";

    private NetUtils() {
    }

    public static String getLocalHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress == null ? UNKNOWN_LOCALHOST : inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            String string;
                            InetAddress inetAddress = enumeration2.nextElement();
                            if (inetAddress.isLoopbackAddress() || (string = inetAddress.getHostName()) == null) continue;
                            return string;
                        }
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            LOGGER.error("Could not determine local host name", (Throwable)unknownHostException);
            return UNKNOWN_LOCALHOST;
        }
    }

    public static byte[] getMacAddress() {
        byte[] byArray = null;
        try {
            Object object;
            InetAddress inetAddress = InetAddress.getLocalHost();
            try {
                Enumeration<NetworkInterface> enumeration;
                object = NetworkInterface.getByInetAddress(inetAddress);
                if (NetUtils.isUpAndNotLoopback((NetworkInterface)object)) {
                    byArray = ((NetworkInterface)object).getHardwareAddress();
                }
                if (byArray == null && (enumeration = NetworkInterface.getNetworkInterfaces()) != null) {
                    while (enumeration.hasMoreElements() && byArray == null) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        if (!NetUtils.isUpAndNotLoopback(networkInterface)) continue;
                        byArray = networkInterface.getHardwareAddress();
                    }
                }
            }
            catch (SocketException socketException) {
                LOGGER.catching(socketException);
            }
            if (ArrayUtils.isEmpty(byArray) && inetAddress != null) {
                object = inetAddress.getAddress();
                byArray = Arrays.copyOf((byte[])object, 6);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return byArray;
    }

    public static String getMacAddressString() {
        byte[] byArray = NetUtils.getMacAddress();
        if (!ArrayUtils.isEmpty(byArray)) {
            StringBuilder stringBuilder = new StringBuilder(String.format("%02x", byArray[0]));
            for (int i2 = 1; i2 < byArray.length; ++i2) {
                stringBuilder.append(":").append(String.format("%02x", byArray[i2]));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static boolean isUpAndNotLoopback(NetworkInterface networkInterface) throws SocketException {
        return networkInterface != null && !networkInterface.isLoopback() && networkInterface.isUp();
    }

    public static URI toURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                URL uRL = new URL(string);
                return new URI(uRL.getProtocol(), uRL.getHost(), uRL.getPath(), null);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                return new File(string).toURI();
            }
        }
    }
}

